/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationBasedServerList
extends AbstractServerList<Server> {
    private IClientConfig clientConfig;

    @Override
    public List<Server> getInitialListOfServers() {
        return this.getUpdatedListOfServers();
    }

    @Override
    public List<Server> getUpdatedListOfServers() {
        String listOfServers = (String)this.clientConfig.get(CommonClientConfigKey.ListOfServers);
        return this.derive(listOfServers);
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    protected List<Server> derive(String value) {
        ArrayList list = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)value)) {
            for (String s : value.split(",")) {
                list.add(new Server(s.trim()));
            }
        }
        return list;
    }
}

