/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.support;

import com.netflix.client.ClientRequest;
import java.net.URI;
import java.util.List;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.util.MultiValueMap;

public abstract class ContextAwareRequest
extends ClientRequest
implements HttpRequest {
    protected final RibbonCommandContext context;
    private HttpHeaders httpHeaders;

    public ContextAwareRequest(RibbonCommandContext context) {
        this.context = context;
        MultiValueMap<String, String> headers = context.getHeaders();
        this.httpHeaders = new HttpHeaders();
        for (String key : headers.keySet()) {
            this.httpHeaders.put(key, (List)headers.get((Object)key));
        }
        this.uri = context.uri();
        this.isRetriable = context.getRetryable();
        this.loadBalancerKey = context.getLoadBalancerKey();
    }

    public RibbonCommandContext getContext() {
        return this.context;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.context.getMethod());
    }

    public URI getURI() {
        return this.getUri();
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    protected RibbonCommandContext newContext(URI uri) {
        RibbonCommandContext commandContext = new RibbonCommandContext(this.context.getServiceId(), this.context.getMethod(), uri.toString(), this.context.getRetryable(), this.context.getHeaders(), this.context.getParams(), this.context.getRequestEntity(), this.context.getRequestCustomizers(), this.context.getContentLength(), this.context.getLoadBalancerKey());
        return commandContext;
    }
}

