/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.encoding;

import feign.Feign;
import feign.httpclient.ApacheHttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.feign.FeignAutoConfiguration;
import org.springframework.cloud.netflix.feign.encoding.FeignClientEncodingProperties;
import org.springframework.cloud.netflix.feign.encoding.FeignContentGzipEncodingInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={FeignClientEncodingProperties.class})
@ConditionalOnClass(value={Feign.class})
@ConditionalOnBean(value={ApacheHttpClient.class})
@ConditionalOnProperty(value={"feign.compression.request.enabled"}, matchIfMissing=false)
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
public class FeignContentGzipEncodingAutoConfiguration {
    @Bean
    public FeignContentGzipEncodingInterceptor feignContentGzipEncodingInterceptor(FeignClientEncodingProperties properties) {
        return new FeignContentGzipEncodingInterceptor(properties);
    }
}

