/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExceptionUtils {
    private static final Log log = LogFactory.getLog(ExceptionUtils.class);
    private static boolean fail = false;
    private static Exception lastException = null;

    private ExceptionUtils() {
        throw new IllegalStateException("Utility class can't be instantiated");
    }

    public static void warn(String msg) {
        log.warn((Object)msg);
        if (fail) {
            IllegalStateException exception = new IllegalStateException(msg);
            lastException = exception;
            throw exception;
        }
    }

    public static Exception getLastException() {
        return lastException;
    }

    public static void setFail(boolean fail) {
        ExceptionUtils.fail = fail;
        lastException = null;
    }

    public static String getExceptionMessage(Throwable e) {
        return e.getMessage() != null ? e.getMessage() : e.toString();
    }
}

