/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.trace;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.core.NamedThreadLocal;

class SpanContextHolder {
    private static final Log log = LogFactory.getLog(SpanContextHolder.class);
    private static final ThreadLocal<SpanContext> CURRENT_SPAN = new NamedThreadLocal("Trace Context");

    SpanContextHolder() {
    }

    static Span getCurrentSpan() {
        return SpanContextHolder.isTracing() ? SpanContextHolder.CURRENT_SPAN.get().span : null;
    }

    static void setCurrentSpan(Span span) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Setting current span " + span));
        }
        SpanContextHolder.push(span, false);
    }

    static void removeCurrentSpan() {
        CURRENT_SPAN.remove();
    }

    static boolean isTracing() {
        return CURRENT_SPAN.get() != null;
    }

    static void close(SpanFunction spanFunction) {
        SpanContext current = CURRENT_SPAN.get();
        CURRENT_SPAN.remove();
        while (current != null) {
            current = current.parent;
            spanFunction.apply(current != null ? current.span : null);
            if (current == null || current.autoClose) continue;
            CURRENT_SPAN.set(current);
            current = null;
        }
    }

    static void close() {
        SpanContextHolder.close(new NoOpFunction());
    }

    static void push(Span span, boolean autoClose) {
        if (SpanContextHolder.isCurrent(span)) {
            return;
        }
        CURRENT_SPAN.set(new SpanContext(span, autoClose));
    }

    private static boolean isCurrent(Span span) {
        if (span == null || CURRENT_SPAN.get() == null) {
            return false;
        }
        return span.equals(SpanContextHolder.CURRENT_SPAN.get().span);
    }

    private static class NoOpFunction
    implements SpanFunction {
        private NoOpFunction() {
        }

        @Override
        public void apply(Span span) {
        }
    }

    static interface SpanFunction {
        public void apply(Span var1);
    }

    private static class SpanContext {
        final Span span;
        final boolean autoClose;
        final SpanContext parent;

        public SpanContext(Span span, boolean autoClose) {
            this.span = span;
            this.autoClose = autoClose;
            this.parent = (SpanContext)CURRENT_SPAN.get();
        }
    }
}

