/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.netflix.ribbon.support.RibbonRequestCustomizer;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.Tracer;

abstract class SpanInjectingRibbonRequestCustomizer<T>
implements RibbonRequestCustomizer<T>,
SpanInjector<SpanTextMap> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;

    SpanInjectingRibbonRequestCustomizer(Tracer tracer) {
        this.tracer = tracer;
    }

    public void customize(T context) {
        Span span = this.getCurrentSpan();
        this.inject(span, this.toSpanTextMap(context));
        span.logEvent("cs");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span in the RibbonRequestCustomizer is" + span));
        }
    }

    protected abstract SpanTextMap toSpanTextMap(T var1);

    @Override
    public void inject(Span span, SpanTextMap carrier) {
        if (span == null) {
            carrier.put("X-B3-Sampled", "0");
            return;
        }
        carrier.put("X-B3-Sampled", span.isExportable() ? "1" : "0");
        carrier.put("X-B3-TraceId", span.traceIdString());
        carrier.put("X-B3-SpanId", Span.idToHex(span.getSpanId()));
        carrier.put("X-Span-Name", span.getName());
        if (this.getParentId(span) != null) {
            carrier.put("X-B3-ParentSpanId", Span.idToHex(this.getParentId(span)));
        }
        carrier.put("X-Process-Id", span.getProcessId());
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }
}

