/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import java.io.IOException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

@Aspect
class TraceFeignAspect {
    private final BeanFactory beanFactory;

    TraceFeignAspect(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Around(value="execution (* feign.Client.*(..)) && !within(is(FinalType))")
    public Object feignClientWasCalled(ProceedingJoinPoint pjp) throws Throwable {
        Object wrappedBean;
        Object bean = pjp.getTarget();
        if (bean != (wrappedBean = new TraceFeignObjectWrapper(this.beanFactory).wrap(bean))) {
            return this.executeTraceFeignClient(bean, pjp);
        }
        return pjp.proceed();
    }

    Object executeTraceFeignClient(Object bean, ProceedingJoinPoint pjp) throws IOException {
        Object[] args = pjp.getArgs();
        Request request = (Request)args[0];
        Request.Options options = (Request.Options)args[1];
        return ((Client)bean).execute(request, options);
    }
}

