/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Feign;
import feign.Retryer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

final class SleuthFeignBuilder {
    private SleuthFeignBuilder() {
    }

    static Feign.Builder builder(BeanFactory beanFactory) {
        return Feign.builder().retryer(Retryer.NEVER_RETRY).client(SleuthFeignBuilder.client(beanFactory));
    }

    private static Client client(BeanFactory beanFactory) {
        try {
            Client client = (Client)beanFactory.getBean(Client.class);
            return (Client)new TraceFeignObjectWrapper(beanFactory).wrap(client);
        }
        catch (BeansException e) {
            return new TraceFeignClient(beanFactory);
        }
    }
}

