/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.okhttp.OkHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

final class OkHttpFeignClientBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private TraceFeignObjectWrapper traceFeignObjectWrapper;

    OkHttpFeignClientBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof OkHttpClient) {
            return this.getTraceFeignObjectWrapper().wrap(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private TraceFeignObjectWrapper getTraceFeignObjectWrapper() {
        if (this.traceFeignObjectWrapper == null) {
            this.traceFeignObjectWrapper = (TraceFeignObjectWrapper)this.beanFactory.getBean(TraceFeignObjectWrapper.class);
        }
        return this.traceFeignObjectWrapper;
    }
}

