/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.client.RestTemplateInterceptorInjector;
import org.springframework.cloud.sleuth.instrument.web.client.SleuthWebClientEnabled;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceUserInfoRestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.web.client.RestTemplate;

@Configuration
@SleuthWebClientEnabled
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={HttpTraceKeysInjector.class})
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TraceWebClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public TraceRestTemplateInterceptor traceRestTemplateInterceptor(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, ErrorParser errorParser) {
        return new TraceRestTemplateInterceptor(tracer, spanInjector, httpTraceKeysInjector, errorParser);
    }

    @Bean
    public BeanPostProcessor traceRestTemplateBuilderBPP(BeanFactory beanFactory) {
        return new TraceRestTemplateBuilderBPP(beanFactory);
    }

    @Configuration
    @ConditionalOnClass(value={UserInfoRestTemplateCustomizer.class, OAuth2RestTemplate.class})
    protected static class TraceOAuthConfiguration {
        @Autowired
        BeanFactory beanFactory;

        protected TraceOAuthConfiguration() {
        }

        @Bean
        UserInfoRestTemplateCustomizerBPP userInfoRestTemplateCustomizerBeanPostProcessor() {
            return new UserInfoRestTemplateCustomizerBPP(this.beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        UserInfoRestTemplateCustomizer traceUserInfoRestTemplateCustomizer() {
            return new TraceUserInfoRestTemplateCustomizer(this.beanFactory);
        }

        private static class UserInfoRestTemplateCustomizerBPP
        implements BeanPostProcessor {
            private final BeanFactory beanFactory;

            UserInfoRestTemplateCustomizerBPP(BeanFactory beanFactory) {
                this.beanFactory = beanFactory;
            }

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                BeanFactory beanFactory = this.beanFactory;
                if (bean instanceof UserInfoRestTemplateCustomizer && !(bean instanceof TraceUserInfoRestTemplateCustomizer)) {
                    return new TraceUserInfoRestTemplateCustomizer(beanFactory, bean);
                }
                return bean;
            }
        }
    }

    @Configuration
    protected static class TraceInterceptorConfiguration {
        @Autowired(required=false)
        private Collection<RestTemplate> restTemplates;
        @Autowired
        private TraceRestTemplateInterceptor traceRestTemplateInterceptor;

        protected TraceInterceptorConfiguration() {
        }

        @PostConstruct
        public void init() {
            if (this.restTemplates != null) {
                for (RestTemplate restTemplate : this.restTemplates) {
                    new RestTemplateInterceptorInjector(this.traceRestTemplateInterceptor).inject(restTemplate);
                }
            }
        }
    }

    private static class TraceRestTemplateBuilderBPP
    implements BeanPostProcessor {
        private final BeanFactory beanFactory;

        private TraceRestTemplateBuilderBPP(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
            return o;
        }

        public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
            if (o instanceof RestTemplateBuilder) {
                RestTemplateBuilder builder = (RestTemplateBuilder)o;
                return builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{(ClientHttpRequestInterceptor)this.beanFactory.getBean(TraceRestTemplateInterceptor.class)});
            }
            return o;
        }
    }
}

