/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.cloud.sleuth.instrument.web.client.TraceRestTemplateInterceptor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public class TraceHttpResponse
implements ClientHttpResponse {
    private final ClientHttpResponse delegate;
    private final TraceRestTemplateInterceptor interceptor;

    public TraceHttpResponse(TraceRestTemplateInterceptor interceptor, ClientHttpResponse delegate) {
        this.interceptor = interceptor;
        this.delegate = delegate;
    }

    public HttpHeaders getHeaders() {
        return this.delegate.getHeaders();
    }

    public InputStream getBody() throws IOException {
        return this.delegate.getBody();
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.delegate.getStatusCode();
    }

    public int getRawStatusCode() throws IOException {
        return this.delegate.getRawStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.delegate.getStatusText();
    }

    public void close() {
        try {
            this.delegate.close();
        }
        finally {
            this.interceptor.finish();
        }
    }
}

