/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceCallable;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.web.context.request.async.WebAsyncTask;

@Aspect
public class TraceWebAspect {
    private static final Log log = LogFactory.getLog(TraceWebAspect.class);
    private final Tracer tracer;
    private final SpanNamer spanNamer;
    private final TraceKeys traceKeys;
    private final ErrorParser errorParser;

    public TraceWebAspect(Tracer tracer, SpanNamer spanNamer, TraceKeys traceKeys, ErrorParser errorParser) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
        this.traceKeys = traceKeys;
        this.errorParser = errorParser;
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    private void anyRestControllerAnnotated() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    private void anyControllerAnnotated() {
    }

    @Pointcut(value="execution(public java.util.concurrent.Callable *(..))")
    private void anyPublicMethodReturningCallable() {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningCallable()")
    private void anyControllerOrRestControllerWithPublicAsyncMethod() {
    }

    @Pointcut(value="execution(public org.springframework.web.context.request.async.WebAsyncTask *(..))")
    private void anyPublicMethodReturningWebAsyncTask() {
    }

    @Pointcut(value="execution(public * org.springframework.web.servlet.HandlerExceptionResolver.resolveException(..)) && args(request, response, handler, ex)")
    private void anyHandlerExceptionResolver(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningWebAsyncTask()")
    private void anyControllerOrRestControllerWithPublicWebAsyncTaskMethod() {
    }

    @Around(value="anyControllerOrRestControllerWithPublicAsyncMethod()")
    public Object wrapWithCorrelationId(ProceedingJoinPoint pjp) throws Throwable {
        Callable callable = (Callable)pjp.proceed();
        if (this.tracer.isTracing()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrapping callable with span [" + this.tracer.getCurrentSpan() + "]"));
            }
            return new SpanContinuingTraceCallable(this.tracer, this.traceKeys, this.spanNamer, callable);
        }
        return callable;
    }

    @Around(value="anyControllerOrRestControllerWithPublicWebAsyncTaskMethod()")
    public Object wrapWebAsyncTaskWithCorrelationId(ProceedingJoinPoint pjp) throws Throwable {
        WebAsyncTask webAsyncTask = (WebAsyncTask)pjp.proceed();
        if (this.tracer.isTracing()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Wrapping callable with span [" + this.tracer.getCurrentSpan() + "]"));
                }
                Field callableField = WebAsyncTask.class.getDeclaredField("callable");
                callableField.setAccessible(true);
                callableField.set(webAsyncTask, new SpanContinuingTraceCallable(this.tracer, this.traceKeys, this.spanNamer, webAsyncTask.getCallable()));
            }
            catch (NoSuchFieldException ex) {
                log.warn((Object)"Cannot wrap webAsyncTask's callable with TraceCallable", (Throwable)ex);
            }
        }
        return webAsyncTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="anyHandlerExceptionResolver(request, response, handler, ex)")
    public Object markRequestForSpanClosing(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Throwable {
        Span currentSpan = this.tracer.getCurrentSpan();
        try {
            if (currentSpan != null && !currentSpan.tags().containsKey("error")) {
                this.errorParser.parseErrorTags(currentSpan, ex);
            }
            Object object = pjp.proceed();
            return object;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking span " + currentSpan + " for closure by Trace Filter"));
            }
            request.setAttribute(TraceFilter.TRACE_CLOSE_SPAN_REQUEST_ATTR, (Object)true);
        }
    }
}

