/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.web.util.UrlPathHelper;

class HttpServletRequestTextMap
implements SpanTextMap {
    private final HttpServletRequest delegate;
    private final UrlPathHelper urlPathHelper;

    HttpServletRequestTextMap(HttpServletRequest delegate) {
        this.delegate = delegate;
        this.urlPathHelper = new UrlPathHelper();
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Enumeration headerNames = this.delegate.getHeaderNames();
        return new Iterator<Map.Entry<String, String>>(){
            private boolean useAdditionalHeader = true;

            @Override
            public boolean hasNext() {
                return this.useAdditionalHeader || headerNames != null && headerNames.hasMoreElements();
            }

            @Override
            public Map.Entry<String, String> next() {
                if (this.useAdditionalHeader) {
                    this.useAdditionalHeader = false;
                    return new AbstractMap.SimpleImmutableEntry<String, String>("X-Span-Uri", HttpServletRequestTextMap.this.urlPathHelper.getPathWithinApplication(HttpServletRequestTextMap.this.delegate));
                }
                String name = (String)headerNames.nextElement();
                String value = HttpServletRequestTextMap.this.delegate.getHeader(name);
                return new AbstractMap.SimpleEntry<String, String>(name, value);
            }
        };
    }

    @Override
    public void put(String key, String value) {
        throw new UnsupportedOperationException("change servlet request isn't supported");
    }
}

