/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.IntegrationTraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.TraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.TraceSpanMessagingAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.GlobalChannelInterceptor;

@Configuration
@ConditionalOnClass(value={GlobalChannelInterceptor.class})
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class, TraceSpanMessagingAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.sleuth.integration.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TraceKeys.class})
public class TraceSpringIntegrationAutoConfiguration {
    @Bean
    @GlobalChannelInterceptor(patterns={"${spring.sleuth.integration.patterns:*}"})
    public TraceChannelInterceptor traceChannelInterceptor(BeanFactory beanFactory) {
        return new IntegrationTraceChannelInterceptor(beanFactory);
    }
}

