/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.hystrix;

import com.netflix.hystrix.HystrixCommand;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;

public abstract class TraceCommand<R>
extends HystrixCommand<R> {
    private static final String HYSTRIX_COMPONENT = "hystrix";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final Span parentSpan;

    protected TraceCommand(Tracer tracer, TraceKeys traceKeys, HystrixCommand.Setter setter) {
        super(setter);
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.parentSpan = tracer.getCurrentSpan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R run() throws Exception {
        String commandKeyName = this.getCommandKey().name();
        Span span = this.startSpan(commandKeyName);
        this.tracer.addTag("lc", HYSTRIX_COMPONENT);
        this.tracer.addTag(this.traceKeys.getHystrix().getPrefix() + this.traceKeys.getHystrix().getCommandKey(), commandKeyName);
        this.tracer.addTag(this.traceKeys.getHystrix().getPrefix() + this.traceKeys.getHystrix().getCommandGroup(), this.getCommandGroup().name());
        this.tracer.addTag(this.traceKeys.getHystrix().getPrefix() + this.traceKeys.getHystrix().getThreadPoolKey(), this.getThreadPoolKey().name());
        try {
            R r = this.doRun();
            return r;
        }
        finally {
            this.close(span);
        }
    }

    private Span startSpan(String commandKeyName) {
        Span span = this.parentSpan;
        if (span == null) {
            return this.tracer.createSpan(commandKeyName, this.parentSpan);
        }
        return this.tracer.continueSpan(span);
    }

    private void close(Span span) {
        if (this.parentSpan == null) {
            this.tracer.close(span);
        } else {
            this.tracer.detach(span);
        }
    }

    public abstract R doRun() throws Exception;
}

