/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.TraceRunnable;
import org.springframework.cloud.sleuth.Tracer;

public class LocalComponentTraceRunnable
extends TraceRunnable {
    protected static final String ASYNC_COMPONENT = "async";
    private final TraceKeys traceKeys;

    public LocalComponentTraceRunnable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate) {
        super(tracer, spanNamer, delegate);
        this.traceKeys = traceKeys;
    }

    public LocalComponentTraceRunnable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Runnable delegate, String name) {
        super(tracer, spanNamer, delegate, name);
        this.traceKeys = traceKeys;
    }

    @Override
    public void run() {
        Span span = this.startSpan();
        try {
            this.getDelegate().run();
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected Span startSpan() {
        Span span = this.getTracer().createSpan(this.getSpanName(), this.getParent());
        this.getTracer().addTag("lc", ASYNC_COMPONENT);
        this.getTracer().addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getThreadNameKey(), Thread.currentThread().getName());
        return span;
    }
}

