/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceCallable;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;

public class LocalComponentTraceCallable<V>
extends TraceCallable<V> {
    protected static final String ASYNC_COMPONENT = "async";
    private final TraceKeys traceKeys;

    public LocalComponentTraceCallable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, Callable<V> delegate) {
        super(tracer, spanNamer, delegate);
        this.traceKeys = traceKeys;
    }

    public LocalComponentTraceCallable(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer, String name, Callable<V> delegate) {
        super(tracer, spanNamer, delegate, name);
        this.traceKeys = traceKeys;
    }

    @Override
    public V call() throws Exception {
        Span span = this.startSpan();
        try {
            Object v = this.getDelegate().call();
            return v;
        }
        finally {
            this.close(span);
        }
    }

    @Override
    protected Span startSpan() {
        Span span = this.getTracer().createSpan(this.getSpanName(), this.getParent());
        this.getTracer().addTag("lc", ASYNC_COMPONENT);
        this.getTracer().addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getThreadNameKey(), Thread.currentThread().getName());
        return span;
    }
}

