/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable;

public class LazyTraceExecutor
implements Executor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private Tracer tracer;
    private final BeanFactory beanFactory;
    private final Executor delegate;
    private TraceKeys traceKeys;
    private SpanNamer spanNamer;

    public LazyTraceExecutor(BeanFactory beanFactory, Executor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        if (this.tracer == null) {
            try {
                this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.delegate.execute(command);
                return;
            }
        }
        this.delegate.execute(new SpanContinuingTraceRunnable(this.tracer, this.traceKeys(), this.spanNamer(), command));
    }

    private TraceKeys traceKeys() {
        if (this.traceKeys == null) {
            try {
                this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"TraceKeys bean not found - will provide a manually created instance");
                return new TraceKeys();
            }
        }
        return this.traceKeys;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

