/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.attr.AbstractConditionalVisibilityAttrProcessor;
import org.thymeleaf.standard.expression.EqualsExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.standard.processor.attr.AbstractStandardSwitchStructureAttrProcessor;
import org.thymeleaf.util.EvaluationUtil;

public abstract class AbstractStandardCaseAttrProcessor
extends AbstractConditionalVisibilityAttrProcessor {
    public static final String CASE_DEFAULT_ATTRIBUTE_VALUE = "*";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractStandardCaseAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardCaseAttrProcessor(String attributeName) {
        super(attributeName);
    }

    protected boolean isVisible(Arguments arguments, Element element, String attributeName) {
        if (!arguments.hasLocalVariable("[%SWITCH_EXPR%]")) {
            throw new TemplateProcessingException("Cannot specify a \"" + attributeName + "\" attribute in an environment where no switch operator has been defined before.");
        }
        AbstractStandardSwitchStructureAttrProcessor.SwitchStructure switchStructure = (AbstractStandardSwitchStructureAttrProcessor.SwitchStructure)arguments.getLocalVariable("[%SWITCH_EXPR%]");
        if (switchStructure.isExecuted()) {
            return false;
        }
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue != null && attributeValue.trim().equals(CASE_DEFAULT_ATTRIBUTE_VALUE)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[THYMELEAF][{}][{}] Case expression \"{}\" in attribute \"{}\" has been evaluated as: \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), attributeValue, attributeName, attributeValue, Boolean.TRUE});
            }
            switchStructure.setExecuted(true);
            return true;
        }
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(configuration);
        IStandardExpression caseExpression = expressionParser.parseExpression(configuration, arguments, attributeValue);
        EqualsExpression equalsExpression = new EqualsExpression(switchStructure.getExpression(), caseExpression);
        Object value = equalsExpression.execute(configuration, arguments);
        boolean visible = EvaluationUtil.evaluateAsBoolean(value);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[THYMELEAF][{}][{}] Case expression \"{}\" in attribute \"{}\" has been evaluated as: \"{}\"", new Object[]{TemplateEngine.threadIndex(), arguments.getTemplateName(), attributeValue, attributeName, attributeValue, visible});
        }
        if (visible) {
            switchStructure.setExecuted(true);
        }
        return visible;
    }
}

