/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.Each;
import org.thymeleaf.standard.expression.EachUtils;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionSequence;
import org.thymeleaf.standard.expression.ExpressionSequenceUtils;
import org.thymeleaf.standard.expression.FragmentSelection;
import org.thymeleaf.standard.expression.FragmentSelectionUtils;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.thymeleaf.util.Validate;

public final class StandardExpressionParser
implements IStandardExpressionParser {
    @Deprecated
    public Expression parseExpression(Arguments arguments, String input) {
        Validate.notNull(arguments, "Arguments cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return (Expression)StandardExpressionParser.parseExpression(arguments.getConfiguration(), arguments, input, true);
    }

    public Expression parseExpression(Configuration configuration, IProcessingContext processingContext, String input) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Processing Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        return (Expression)StandardExpressionParser.parseExpression(configuration, processingContext, input, true);
    }

    @Deprecated
    public AssignationSequence parseAssignationSequence(Arguments arguments, String input, boolean allowParametersWithoutValue) {
        return this.parseAssignationSequence(arguments.getConfiguration(), arguments, input, allowParametersWithoutValue);
    }

    public AssignationSequence parseAssignationSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean allowParametersWithoutValue) {
        return AssignationUtils.parseAssignationSequence(configuration, processingContext, input, allowParametersWithoutValue);
    }

    @Deprecated
    public ExpressionSequence parseExpressionSequence(Arguments arguments, String input) {
        return this.parseExpressionSequence(arguments.getConfiguration(), arguments, input);
    }

    public ExpressionSequence parseExpressionSequence(Configuration configuration, IProcessingContext processingContext, String input) {
        return ExpressionSequenceUtils.parseExpressionSequence(configuration, processingContext, input);
    }

    @Deprecated
    public Each parseEach(Arguments arguments, String input) {
        return this.parseEach(arguments.getConfiguration(), arguments, input);
    }

    public Each parseEach(Configuration configuration, IProcessingContext processingContext, String input) {
        return EachUtils.parseEach(configuration, processingContext, input);
    }

    @Deprecated
    public FragmentSelection parseFragmentSelection(Arguments arguments, String input) {
        return this.parseFragmentSelection(arguments.getConfiguration(), arguments, input);
    }

    public FragmentSelection parseFragmentSelection(Configuration configuration, IProcessingContext processingContext, String input) {
        return FragmentSelectionUtils.parseFragmentSelection(configuration, processingContext, input);
    }

    public FragmentSignature parseFragmentSignature(Configuration configuration, IProcessingContext processingContext, String input) {
        return FragmentSignatureUtils.parseFragmentSignature(configuration, input);
    }

    static IStandardExpression parseExpression(Configuration configuration, IProcessingContext processingContext, String input, boolean preprocess) {
        IStandardExpression cachedExpression;
        String preprocessedInput;
        String string = preprocessedInput = preprocess ? StandardExpressionPreprocessor.preprocess(configuration, processingContext, input) : input;
        if (configuration != null && (cachedExpression = ExpressionCache.getExpressionFromCache(configuration, preprocessedInput)) != null) {
            return cachedExpression;
        }
        Expression expression = Expression.parse(preprocessedInput.trim());
        if (expression == null) {
            throw new TemplateProcessingException("Could not parse as expression: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putExpressionIntoCache(configuration, preprocessedInput, expression);
        }
        return expression;
    }

    public String toString() {
        return "Standard Expression Parser";
    }
}

