/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.BinaryOperationExpression;
import org.thymeleaf.standard.expression.BooleanTokenExpression;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.Token;
import org.thymeleaf.util.EvaluationUtil;

public final class OrExpression
extends BinaryOperationExpression {
    private static final long serialVersionUID = -8085738202412415337L;
    private static final Logger logger = LoggerFactory.getLogger(OrExpression.class);
    private static final String OPERATOR = "or";
    static final String[] OPERATORS = new String[]{"or"};
    private static final boolean[] LENIENCIES = new boolean[]{false};
    private static final Class<? extends BinaryOperationExpression>[] OPERATOR_CLASSES = new Class[]{OrExpression.class};
    private static final Method LEFT_ALLOWED_METHOD;
    private static final Method RIGHT_ALLOWED_METHOD;

    public OrExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation(OPERATOR);
    }

    static boolean isRightAllowed(IStandardExpression right) {
        return right != null && (!(right instanceof Token) || right instanceof BooleanTokenExpression);
    }

    static boolean isLeftAllowed(IStandardExpression left) {
        return left != null && (!(left instanceof Token) || left instanceof BooleanTokenExpression);
    }

    static ExpressionParsingState composeOrExpression(ExpressionParsingState state, int inputIndex) {
        return OrExpression.composeBinaryOperationExpression(state, inputIndex, OPERATORS, LENIENCIES, OPERATOR_CLASSES, LEFT_ALLOWED_METHOD, RIGHT_ALLOWED_METHOD);
    }

    static Object executeOr(Configuration configuration, IProcessingContext processingContext, OrExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue;
        boolean leftBooleanValue;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating OR expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (leftBooleanValue = EvaluationUtil.evaluateAsBoolean(leftValue = expression.getLeft().execute(configuration, processingContext, expContext))) {
            return Boolean.TRUE;
        }
        Object rightValue = expression.getRight().execute(configuration, processingContext, expContext);
        boolean rightBooleanValue = EvaluationUtil.evaluateAsBoolean(rightValue);
        return rightBooleanValue;
    }

    static {
        try {
            LEFT_ALLOWED_METHOD = OrExpression.class.getDeclaredMethod("isLeftAllowed", IStandardExpression.class);
            RIGHT_ALLOWED_METHOD = OrExpression.class.getDeclaredMethod("isRightAllowed", IStandardExpression.class);
        }
        catch (NoSuchMethodException e) {
            throw new TemplateProcessingException("Cannot register is*Allowed methods in binary operation expression", e);
        }
    }
}

