/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.VariableExpression;
import org.thymeleaf.util.EvaluationUtil;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class ConditionalExpression
extends ComplexExpression {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalExpression.class);
    private static final long serialVersionUID = -6966177717462316363L;
    private static final char CONDITION_SUFFIX_CHAR = '?';
    private static final char CONDITION_THENELSE_SEPARATOR_CHAR = ':';
    static final String[] OPERATORS = new String[]{String.valueOf('?'), String.valueOf(':')};
    private final Expression conditionExpression;
    private final Expression thenExpression;
    private final Expression elseExpression;

    public ConditionalExpression(Expression conditionExpression, Expression thenExpression, Expression elseExpression) {
        Validate.notNull(conditionExpression, "Condition expression cannot be null");
        Validate.notNull(thenExpression, "Then expression cannot be null");
        Validate.notNull(elseExpression, "Else expression cannot be null");
        this.conditionExpression = conditionExpression;
        this.thenExpression = thenExpression;
        this.elseExpression = elseExpression;
    }

    public Expression getConditionExpression() {
        return this.conditionExpression;
    }

    public Expression getThenExpression() {
        return this.thenExpression;
    }

    public Expression getElseExpression() {
        return this.elseExpression;
    }

    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        if (this.conditionExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.conditionExpression);
            sb.append(')');
        } else {
            sb.append(this.conditionExpression);
        }
        sb.append('?');
        sb.append(' ');
        if (this.thenExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.thenExpression);
            sb.append(')');
        } else {
            sb.append(this.thenExpression);
        }
        sb.append(' ');
        sb.append(':');
        sb.append(' ');
        if (this.elseExpression instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.elseExpression);
            sb.append(')');
        } else {
            sb.append(this.elseExpression);
        }
        return sb.toString();
    }

    static ExpressionParsingState composeConditionalExpression(ExpressionParsingState state, int nodeIndex) {
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int condSuffixPos = input.indexOf(63);
        if (condSuffixPos == -1) {
            return state;
        }
        String condStr = input.substring(0, condSuffixPos);
        String remainder = input.substring(condSuffixPos + 1);
        if (remainder.indexOf(63) != -1) {
            return null;
        }
        int thenElseSepPos = remainder.indexOf(58);
        if (remainder.lastIndexOf(58) != thenElseSepPos) {
            return null;
        }
        String thenStr = null;
        String elseStr = null;
        if (thenElseSepPos != -1) {
            if (thenElseSepPos == 0) {
                return state;
            }
            thenStr = remainder.substring(0, thenElseSepPos);
            elseStr = remainder.substring(thenElseSepPos + 1);
        } else {
            thenStr = remainder;
        }
        Expression condExpr = ExpressionParsingUtil.parseAndCompose(state, condStr);
        if (condExpr == null) {
            return null;
        }
        Expression thenExpr = ExpressionParsingUtil.parseAndCompose(state, thenStr);
        if (thenExpr == null) {
            return null;
        }
        Expression elseExpr = VariableExpression.NULL_VALUE;
        if (elseStr != null && (elseExpr = ExpressionParsingUtil.parseAndCompose(state, elseStr)) == null) {
            return null;
        }
        ConditionalExpression conditionalExpressionResult = new ConditionalExpression(condExpr, thenExpr, elseExpr);
        state.setNode(nodeIndex, conditionalExpressionResult);
        return state;
    }

    static Object executeConditional(Configuration configuration, IProcessingContext processingContext, ConditionalExpression expression, StandardExpressionExecutionContext expContext) {
        Object condObj;
        boolean cond;
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating conditional expression: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        if (cond = EvaluationUtil.evaluateAsBoolean(condObj = expression.getConditionExpression().execute(configuration, processingContext, expContext))) {
            return expression.getThenExpression().execute(configuration, processingContext, expContext);
        }
        return expression.getElseExpression().execute(configuration, processingContext, expContext);
    }
}

