/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ComplexExpression;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryOperationExpression
extends ComplexExpression {
    private static final long serialVersionUID = 7524261639178859585L;
    private final IStandardExpression left;
    private final IStandardExpression right;

    protected BinaryOperationExpression(IStandardExpression left, IStandardExpression right) {
        Validate.notNull(left, "Left-side expression cannot be null");
        Validate.notNull(right, "Right-side expression cannot be null");
        this.left = left;
        this.right = right;
    }

    public IStandardExpression getLeft() {
        return this.left;
    }

    public IStandardExpression getRight() {
        return this.right;
    }

    protected String getStringRepresentation(String operator) {
        StringBuilder sb = new StringBuilder();
        if (this.left instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.left);
            sb.append(')');
        } else {
            sb.append(this.left);
        }
        sb.append(' ');
        sb.append(operator);
        sb.append(' ');
        if (this.right instanceof ComplexExpression) {
            sb.append('(');
            sb.append(this.right);
            sb.append(')');
        } else {
            sb.append(this.right);
        }
        return sb.toString();
    }

    protected static ExpressionParsingState composeBinaryOperationExpression(ExpressionParsingState state, int nodeIndex, String[] operators, boolean[] leniencies, Class<? extends BinaryOperationExpression>[] operationClasses, Method leftAllowedMethod, Method rightAllowedMethod) {
        block4: {
            String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
            if (StringUtils.isEmptyOrWhitespace(input)) {
                return null;
            }
            String scannedInput = input.toLowerCase();
            while (true) {
                int operatorIndex = -1;
                int operatorPosFrom = -1;
                int operatorPosTo = Integer.MAX_VALUE;
                int operatorLen = 0;
                for (int i = 0; i < operators.length; ++i) {
                    int currentOperatorPosFrom = scannedInput.lastIndexOf(operators[i]);
                    if (currentOperatorPosFrom == -1) continue;
                    int currentOperatorLen = operators[i].length();
                    int currentOperatorPosTo = currentOperatorPosFrom + currentOperatorLen;
                    if (operatorPosFrom != -1 && operatorPosTo >= currentOperatorPosFrom && (currentOperatorLen <= operatorLen || currentOperatorPosTo < operatorPosTo)) continue;
                    operatorPosFrom = currentOperatorPosFrom;
                    operatorLen = operators[i].length();
                    operatorPosTo = currentOperatorPosFrom + operatorLen;
                    operatorIndex = i;
                }
                if (operatorPosFrom == -1) {
                    return state;
                }
                if (BinaryOperationExpression.doComposeBinaryOperationExpression(state, nodeIndex, operators[operatorIndex], operationClasses[operatorIndex], leftAllowedMethod, rightAllowedMethod, input, operatorPosFrom) != null) break block4;
                if (!leniencies[operatorIndex]) break;
                scannedInput = scannedInput.substring(0, operatorPosFrom);
            }
            return null;
        }
        return state;
    }

    private static ExpressionParsingState doComposeBinaryOperationExpression(ExpressionParsingState state, int nodeIndex, String operator, Class<? extends BinaryOperationExpression> operationClass, Method leftAllowedMethod, Method rightAllowedMethod, String input, int operatorPos) {
        String leftStr = input.substring(0, operatorPos).trim();
        String rightStr = input.substring(operatorPos + operator.length()).trim();
        if (leftStr.length() == 0 || rightStr.length() == 0) {
            return null;
        }
        Expression leftExpr = ExpressionParsingUtil.parseAndCompose(state, leftStr);
        try {
            if (leftExpr == null || !((Boolean)leftAllowedMethod.invoke(null, leftExpr)).booleanValue()) {
                return null;
            }
        }
        catch (IllegalAccessException e) {
            throw new TemplateProcessingException("Error invoking operand validation in binary operation", e);
        }
        catch (InvocationTargetException e) {
            throw new TemplateProcessingException("Error invoking operand validation in binary operation", e);
        }
        Expression rightExpr = ExpressionParsingUtil.parseAndCompose(state, rightStr);
        try {
            if (rightExpr == null || !((Boolean)rightAllowedMethod.invoke(null, rightExpr)).booleanValue()) {
                return null;
            }
        }
        catch (IllegalAccessException e) {
            throw new TemplateProcessingException("Error invoking operand validation in binary operation", e);
        }
        catch (InvocationTargetException e) {
            throw new TemplateProcessingException("Error invoking operand validation in binary operation", e);
        }
        try {
            BinaryOperationExpression operationExpression = operationClass.getDeclaredConstructor(IStandardExpression.class, IStandardExpression.class).newInstance(leftExpr, rightExpr);
            state.setNode(nodeIndex, operationExpression);
        }
        catch (TemplateProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during creation of Binary Operation expression for operator: \"" + operator + "\"", e);
        }
        return state;
    }
}

