/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.ExpressionParsingDecompositionConfig;
import org.thymeleaf.standard.expression.ExpressionParsingNode;
import org.thymeleaf.standard.expression.ExpressionParsingState;
import org.thymeleaf.standard.expression.ExpressionParsingUtil;
import org.thymeleaf.standard.expression.StandardExpressionPreprocessor;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class AssignationUtils {
    public static AssignationSequence parseAssignationSequence(Configuration configuration, IProcessingContext processingContext, String input, boolean allowParametersWithoutValue) {
        AssignationSequence cachedAssignationSequence;
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(processingContext, "Processing Context cannot be null");
        Validate.notNull(input, "Input cannot be null");
        String preprocessedInput = StandardExpressionPreprocessor.preprocess(configuration, processingContext, input);
        if (configuration != null && (cachedAssignationSequence = ExpressionCache.getAssignationSequenceFromCache(configuration, preprocessedInput)) != null) {
            return cachedAssignationSequence;
        }
        AssignationSequence assignationSequence = AssignationUtils.internalParseAssignationSequence(preprocessedInput.trim(), allowParametersWithoutValue);
        if (assignationSequence == null) {
            throw new TemplateProcessingException("Could not parse as assignation sequence: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putAssignationSequenceIntoCache(configuration, preprocessedInput, assignationSequence);
        }
        return assignationSequence;
    }

    static AssignationSequence internalParseAssignationSequence(String input, boolean allowParametersWithoutValue) {
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        ExpressionParsingState decomposition = ExpressionParsingUtil.decompose(input, ExpressionParsingDecompositionConfig.DECOMPOSE_ALL_AND_UNNEST);
        if (decomposition == null) {
            return null;
        }
        return AssignationUtils.composeSequence(decomposition, 0, allowParametersWithoutValue);
    }

    private static AssignationSequence composeSequence(ExpressionParsingState state, int nodeIndex, boolean allowParametersWithoutValue) {
        String[] inputParts;
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            if (!allowParametersWithoutValue) {
                return null;
            }
            Assignation assignation = AssignationUtils.composeAssignation(state, nodeIndex, allowParametersWithoutValue);
            if (assignation == null) {
                return null;
            }
            ArrayList<Assignation> assignations = new ArrayList<Assignation>(2);
            assignations.add(assignation);
            return new AssignationSequence(assignations);
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int pointer = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(input);
        if (pointer != -1) {
            return AssignationUtils.composeSequence(state, pointer, allowParametersWithoutValue);
        }
        for (String inputPart : inputParts = StringUtils.split(input, ",")) {
            state.addNode(inputPart.trim());
        }
        ArrayList<Assignation> assignations = new ArrayList<Assignation>(4);
        int startIndex = state.size() - inputParts.length;
        int endIndex = state.size();
        for (int i = startIndex; i < endIndex; ++i) {
            Assignation assignation = AssignationUtils.composeAssignation(state, i, allowParametersWithoutValue);
            if (assignation == null) {
                return null;
            }
            assignations.add(assignation);
        }
        return new AssignationSequence(assignations);
    }

    static Assignation composeAssignation(ExpressionParsingState state, int nodeIndex, boolean allowParametersWithoutValue) {
        Expression rightExpr;
        String rightInput;
        if (state == null || nodeIndex >= state.size()) {
            return null;
        }
        if (state.hasExpressionAt(nodeIndex)) {
            if (!allowParametersWithoutValue) {
                return null;
            }
            return new Assignation(((ExpressionParsingNode)state.get(nodeIndex)).getExpression(), null);
        }
        String input = ((ExpressionParsingNode)state.get(nodeIndex)).getInput();
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int pointer = ExpressionParsingUtil.parseAsSimpleIndexPlaceholder(input);
        if (pointer != -1) {
            return AssignationUtils.composeAssignation(state, pointer, allowParametersWithoutValue);
        }
        int inputLen = input.length();
        int operatorPos = input.indexOf(61);
        String leftInput = operatorPos == -1 ? input.trim() : input.substring(0, operatorPos).trim();
        String string = rightInput = operatorPos == -1 || operatorPos == inputLen - 1 ? null : input.substring(operatorPos + 1).trim();
        if (StringUtils.isEmptyOrWhitespace(leftInput)) {
            return null;
        }
        Expression leftExpr = ExpressionParsingUtil.parseAndCompose(state, leftInput);
        if (leftExpr == null) {
            return null;
        }
        if (!StringUtils.isEmptyOrWhitespace(rightInput)) {
            rightExpr = ExpressionParsingUtil.parseAndCompose(state, rightInput);
            if (rightExpr == null) {
                return null;
            }
        } else {
            if (!allowParametersWithoutValue) {
                return null;
            }
            rightExpr = null;
        }
        return new Assignation(leftExpr, rightExpr);
    }

    private AssignationUtils() {
    }
}

