/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IElementNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementNameProcessorMatcher
implements IElementNameProcessorMatcher {
    private final String elementName;
    private final Map<String, String> attributeValuesByNameFilter;
    private final boolean applyDialectPrefix;

    public ElementNameProcessorMatcher(String elementName) {
        this(elementName, true);
    }

    public ElementNameProcessorMatcher(String elementName, boolean applyDialectPrefix) {
        this(elementName, null, applyDialectPrefix);
    }

    public ElementNameProcessorMatcher(String elementName, String filterAttributeName, String filterAttributeValue) {
        this(elementName, filterAttributeName, filterAttributeValue, true);
    }

    public ElementNameProcessorMatcher(String elementName, String filterAttributeName, String filterAttributeValue, boolean applyDialectPrefix) {
        this(elementName, Collections.singletonMap(filterAttributeName, filterAttributeValue), applyDialectPrefix);
    }

    public ElementNameProcessorMatcher(String elementName, Map<String, String> attributeValuesByNameFilter) {
        this(elementName, attributeValuesByNameFilter, true);
    }

    public ElementNameProcessorMatcher(String elementName, Map<String, String> attributeValuesByNameFilter, boolean applyDialectPrefix) {
        Validate.notEmpty(elementName, "Element name cannot be null or empty");
        this.elementName = elementName;
        if (attributeValuesByNameFilter == null || attributeValuesByNameFilter.size() == 0) {
            this.attributeValuesByNameFilter = null;
        } else {
            HashMap<String, String> newAttributeValuesByNameFilter = new HashMap<String, String>(attributeValuesByNameFilter.size() + 1, 1.0f);
            newAttributeValuesByNameFilter.putAll(attributeValuesByNameFilter);
            this.attributeValuesByNameFilter = Collections.unmodifiableMap(newAttributeValuesByNameFilter);
        }
        this.applyDialectPrefix = applyDialectPrefix;
    }

    @Override
    public String[] getElementNames(ProcessorMatchingContext context) {
        if (this.applyDialectPrefix) {
            return Element.applyPrefixToElementName(this.elementName, context.getDialectPrefix());
        }
        return Element.applyPrefixToElementName(this.elementName, null);
    }

    public Map<String, String> getAttributeValuesByNameFilter() {
        return this.attributeValuesByNameFilter;
    }

    public boolean hasFilter() {
        return this.attributeValuesByNameFilter != null;
    }

    @Override
    public boolean matches(Node node, ProcessorMatchingContext context) {
        String prefix;
        if (!(node instanceof Element)) {
            return false;
        }
        Element element = (Element)node;
        String string = prefix = this.applyDialectPrefix ? context.getDialectPrefix() : null;
        if (!element.hasNormalizedName(prefix, this.elementName)) {
            return false;
        }
        if (this.attributeValuesByNameFilter != null) {
            for (Map.Entry<String, String> filterAttributeEntry : this.attributeValuesByNameFilter.entrySet()) {
                String elementAttributeValue;
                String filterAttributeName = filterAttributeEntry.getKey();
                String filterAttributeValue = filterAttributeEntry.getValue();
                if (!(!element.hasAttribute(filterAttributeName) ? filterAttributeValue != null : ((elementAttributeValue = element.getAttributeValue(filterAttributeName)) == null ? filterAttributeValue != null : !elementAttributeValue.equals(filterAttributeValue)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Class<? extends Element> appliesTo() {
        return Element.class;
    }
}

