/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.messageresolver;

import java.util.Map;
import java.util.Properties;
import org.thymeleaf.Arguments;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;
import org.thymeleaf.standard.StandardMessageResolutionUtils;
import org.thymeleaf.util.Validate;

public class StandardMessageResolver
extends AbstractMessageResolver {
    private final Properties defaultMessages = new Properties();

    public Properties getDefaultMessages() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultMessages);
        return properties;
    }

    protected Properties unsafeGetDefaultMessages() {
        return this.defaultMessages;
    }

    public void setDefaultMessages(Properties defaultMessages) {
        this.checkNotInitialized();
        if (defaultMessages != null) {
            this.defaultMessages.putAll((Map<?, ?>)defaultMessages);
        }
    }

    public void addDefaultMessage(String key, String value) {
        this.checkNotInitialized();
        Validate.notNull(key, "Key for default message cannot be null");
        Validate.notNull(value, "Value for default message cannot be null");
        this.defaultMessages.put(key, value);
    }

    public void clearDefaultMessages() {
        this.checkNotInitialized();
        this.defaultMessages.clear();
    }

    public MessageResolution resolveMessage(Arguments arguments, String key, Object[] messageParameters) {
        this.checkInitialized();
        String message = StandardMessageResolutionUtils.resolveMessageForTemplate(arguments, key, messageParameters, this.unsafeGetDefaultMessages());
        if (message == null) {
            return null;
        }
        return new MessageResolution(message);
    }
}

