/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.StringUtils;

public class PluginRegistriesBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class[] types;
        for (Class type : types = (Class[])importingClassMetadata.getAnnotationAttributes(EnablePluginRegistries.class.getName()).get("value")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
            builder.addPropertyValue("type", (Object)type);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            Qualifier annotation = type.getAnnotation(Qualifier.class);
            if (annotation != null) {
                AutowireCandidateQualifier qualifierMetadata = new AutowireCandidateQualifier(Qualifier.class);
                qualifierMetadata.setAttribute(AutowireCandidateQualifier.VALUE_KEY, (Object)annotation.value());
                beanDefinition.addQualifier(qualifierMetadata);
            }
            String beanName = annotation == null ? StringUtils.uncapitalize((String)(type.getSimpleName() + "Registry")) : annotation.value();
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        }
    }
}

