/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.spring4.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

public class Mvc {
    private static final MvcUriComponentsBuilderDelegate mvcUriComponentsBuilderDelegate;
    private static final String SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;
    private static final String NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;

    public MethodArgumentBuilderWrapper url(String mappingName) {
        return mvcUriComponentsBuilderDelegate.fromMappingName(mappingName);
    }

    static {
        SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME = Mvc.class.getName() + "$Spring41MvcUriComponentsBuilderDelegate";
        NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME = Mvc.class.getName() + "$NonSpring41MvcUriComponentsBuilderDelegate";
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(Mvc.class);
        String delegateClassName = SpringVersionUtils.isSpring41AtLeast() ? SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME : NON_SPRING41_MVC_URI_COMPONENTS_BUILDER_DELEGATE_CLASS_NAME;
        try {
            Class<?> implClass = Class.forName(delegateClassName, true, classLoader);
            mvcUriComponentsBuilderDelegate = (MvcUriComponentsBuilderDelegate)implClass.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Thymeleaf could not initialize a delegate of class \"" + delegateClassName + "\" for taking care of the " + "mvc" + " expression utility object", (Throwable)e);
        }
    }

    static class Spring41MethodArgumentBuilderWrapper
    implements MethodArgumentBuilderWrapper {
        private final MvcUriComponentsBuilder.MethodArgumentBuilder builder;

        private Spring41MethodArgumentBuilderWrapper(MvcUriComponentsBuilder.MethodArgumentBuilder builder) {
            this.builder = builder;
        }

        public MethodArgumentBuilderWrapper arg(int index, Object value) {
            return new Spring41MethodArgumentBuilderWrapper(this.builder.arg(index, value));
        }

        public String build() {
            return this.builder.build();
        }

        public String buildAndExpand(Object ... uriVariables) {
            return this.builder.buildAndExpand(uriVariables);
        }
    }

    public static interface MethodArgumentBuilderWrapper {
        public MethodArgumentBuilderWrapper arg(int var1, Object var2);

        public String build();

        public String buildAndExpand(Object ... var1);
    }

    static class NonSpring41MvcUriComponentsBuilderDelegate
    implements MvcUriComponentsBuilderDelegate {
        NonSpring41MvcUriComponentsBuilderDelegate() {
        }

        public MethodArgumentBuilderWrapper fromMappingName(String mappingName) {
            throw new UnsupportedOperationException("MVC URI component building is only supported in Spring versions 4.1 or newer");
        }
    }

    static class Spring41MvcUriComponentsBuilderDelegate
    implements MvcUriComponentsBuilderDelegate {
        Spring41MvcUriComponentsBuilderDelegate() {
        }

        public MethodArgumentBuilderWrapper fromMappingName(String mappingName) {
            return new Spring41MethodArgumentBuilderWrapper(MvcUriComponentsBuilder.fromMappingName((String)mappingName));
        }
    }

    static interface MvcUriComponentsBuilderDelegate {
        public MethodArgumentBuilderWrapper fromMappingName(String var1);
    }
}

