/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestVariableHolder<T> {
    static final Logger logger = LoggerFactory.getLogger(HystrixRequestVariableHolder.class);
    private static ConcurrentHashMap<RVCacheKey, HystrixRequestVariable<?>> requestVariableInstance = new ConcurrentHashMap();
    private final HystrixRequestVariableLifecycle<T> lifeCycleMethods;

    public HystrixRequestVariableHolder(HystrixRequestVariableLifecycle<T> lifeCycleMethods) {
        this.lifeCycleMethods = lifeCycleMethods;
    }

    public T get(HystrixConcurrencyStrategy concurrencyStrategy) {
        RVCacheKey key = new RVCacheKey(this, concurrencyStrategy);
        HystrixRequestVariable<?> rvInstance = requestVariableInstance.get(key);
        if (rvInstance == null) {
            requestVariableInstance.putIfAbsent(key, concurrencyStrategy.getRequestVariable(this.lifeCycleMethods));
            if (requestVariableInstance.size() > 100) {
                logger.warn("Over 100 instances of HystrixRequestVariable are being stored. This is likely the sign of a memory leak caused by using unique instances of HystrixConcurrencyStrategy instead of a single instance.");
            }
        }
        return (T)requestVariableInstance.get(key).get();
    }

    private static class RVCacheKey {
        private final HystrixRequestVariableHolder<?> rvHolder;
        private final HystrixConcurrencyStrategy concurrencyStrategy;

        private RVCacheKey(HystrixRequestVariableHolder<?> rvHolder, HystrixConcurrencyStrategy concurrencyStrategy) {
            this.rvHolder = rvHolder;
            this.concurrencyStrategy = concurrencyStrategy;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.concurrencyStrategy == null ? 0 : this.concurrencyStrategy.hashCode());
            result = 31 * result + (this.rvHolder == null ? 0 : this.rvHolder.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RVCacheKey other = (RVCacheKey)obj;
            if (this.concurrencyStrategy == null ? other.concurrencyStrategy != null : !this.concurrencyStrategy.equals(other.concurrencyStrategy)) {
                return false;
            }
            return !(this.rvHolder == null ? other.rvHolder != null : !this.rvHolder.equals(other.rvHolder));
        }
    }
}

