/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class PersistentEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID> {
    private final PersistentEntity<T, ?> persistentEntity;

    public PersistentEntityInformation(PersistentEntity<T, ?> entity) {
        super(entity.getType());
        this.persistentEntity = entity;
    }

    @Override
    public ID getId(T entity) {
        return (ID)((Serializable)this.persistentEntity.getIdentifierAccessor(entity).getIdentifier());
    }

    @Override
    public Class<ID> getIdType() {
        return this.persistentEntity.getIdProperty().getType();
    }
}

