/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Base64;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
public class FHEFileSystem {
    @JsonProperty(value="fileName")
    private String fileName = null;
    @JsonProperty(value="format")
    private String format = null;
    @JsonProperty(value="contentBase64")
    private String contentBase64 = null;

    public FHEFileSystem fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="filename can be empty or not if defined", required=true, value="")
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FHEFileSystem format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(example="version supported for 'zip', 'tar', '.gz' format", value="")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public FHEFileSystem contentBase64(String contentBase64) {
        this.contentBase64 = contentBase64;
        return this;
    }

    @ApiModelProperty(example="U3dhZ2dlciByb2Nrcw== (CONTENT in BINARY format :  base64-encoded characters)", required=true, value="")
    @NotNull
    public String getContentBase64() {
        return this.contentBase64;
    }

    public void setContentBase64(String contentBase64) {
        this.contentBase64 = contentBase64;
    }

    @JsonIgnore
    public byte[] getContentByteArray() {
        return Base64.getDecoder().decode(this.contentBase64.getBytes());
    }

    @JsonIgnore
    public void setContentBase64(byte[] content) {
        this.contentBase64 = Base64.getEncoder().encodeToString(content);
    }

    public FHEFileSystem contentByteArray(byte[] content) {
        this.contentBase64 = Base64.getEncoder().encodeToString(content);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FHEFileSystem fhEFileSystem = (FHEFileSystem)o;
        return Objects.equals(this.fileName, fhEFileSystem.fileName) && Objects.equals(this.format, fhEFileSystem.format) && Objects.equals(this.contentBase64, fhEFileSystem.contentBase64);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.format, this.contentBase64);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FHEFileSystem {\n");
        sb.append("    fileName: ").append(this.toIndentedString((Object)this.fileName)).append("\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    contentBase64: ").append(this.toIndentedString((Object)this.contentBase64)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

