#!/usr/bin/env groovy
/**
 *  Copyright 2021 Hewlett Packard Enterprise Development Company, L.P.
 */
library 'hpe-jenkins-libs'

// create (or update) the job input parameters
deriveJobParams(name:"security-job")

/**
 * name         always "security-pipeline"
 * productType  the top level project
 * product      your component name
 * buildJob     where to copy artifacts from
 * image        the docker image to test hosted at the HPE_REGISTRY
 * latestTag    the tag of the docker image to test
 */
securityPipeline(name:"security-pipeline",
                 productType:"ECORRIDOR",              
                 product:"iai-openapi",
                 buildJob:"/ECORRIDOR/CSI/iai-openapi-build",
                 image:"ecorridor/iai/iai-openapi",
                 latestTag:"latest"
                )
