#!/usr/bin/env groovy
/**
 *  Copyright 2021 Hewlett Packard Enterprise Development Company, L.P.
 */
library 'hpe-jenkins-libs'

// create (or update) the job input parameters
deriveJobParams(name:"deploy-job")

// if you need to change a YAML file before applying it
// you can use the following snippet
/*node {
  stage("Transform YAML") {
     sh """
     cat mydir/myfile.yaml | sed "s/FOO/BAR/g" > mydir/myfile2.yaml
     """
  }
}*/

// You need to pass:
//   gitlaburl: the git URL
//   gitlabbranch: the branch for git URL
//   gitlabcomposeurl: the git URL to compose project
//   yamls: a list of YAML files for deployment
//   yamlsOverride: a list of YAML files that will replace those in yamls
// all YAML files will have the following transformation
// image tag 'latest' is replaced by version specified in input (PRJ_IMAGE_TAG)
deployPipeline(name:"deploy-pipeline",
               gitlaburl:'git@gitlab.troof.io:data-pi-platform/hoang-gia/dap-pattern-search-standalone.git',
               gitlabbranch:'master',
               gitlabcomposeurl:'git@devecorridor.iit.cnr.it:ecorridor/ecorridor-compose.git',
               wptfolder:'CSI',
               yamls:"['docker/docker-compose_csi-openapi.yml']",
               yamlsOverride:params.YAMLS_OVERRIDE
              )
