#include <iostream>
#include "csv_api.h"
#include "print_api.h"
#include "seal_api.h"
#include "util.h"
// #include <algorithm>
// #include <iterator>
// #include <vector>
// #include <filesystem>

using namespace seal;
using namespace std;

void sub_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out);

void add_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out);

void multiply_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out);

void multiply_ciphertext_ckks(struct cevaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out);

bool is_number(const string &s);

void printStrVector(const vector<string> &v);

vector<vector<string>> split_ends(const vector<string> &data, const vector<int> &ends);

void multiply_ciphertexts(struct evaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out);

void multiply_ciphertexts_ckks(struct cevaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out);

void relinearize_inplace(struct evaluator_t &op_st, Ciphertext &ct);

void rescale_to_next_inplace(struct evaluator_t &op_st, Ciphertext &ct);

void rescale_to_next_inplace_ckks(struct cevaluator_t &op_st, Ciphertext &ct);

void multiply_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2);

void relinearize(struct evaluator_t &op_st, Ciphertext &ct, Ciphertext &ct_out);

void sub_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2);

void negate_inplace__ciphertext(struct evaluator_t &op_st, Ciphertext &ct);

void add_plain_inplace_ciphertext(struct evaluator_t &op_st, struct Ciphertext &ct, const Plaintext &plain);

void add_plain_inplace_ciphertext_ckks(struct cevaluator_t &op_st, struct Ciphertext &ct, const Plaintext &plain);

void multiply_plain_inplace_ckks(struct cevaluator_t &op_st, Ciphertext &ct, const Plaintext &plain);

void add_many_ciphertext(struct evaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out);

void exponentiate_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct, uint64_t &exponent);

void sub_plain_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct, const Plaintext &plain);

void mod_switch_to_next_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct);

int ANNProcess(
    string &wFilePath, string &xCT, string &bFilePath, string &result_name, string &result_dir, int &sample_size,
    string &key_dir);

// string relink_key_path;
// string galois_key_path;
// string public_key_path;
string key_dir = "";

int main(int argc, char **argv)
{
    // input processing - begin
    // string result_name = argv[argc - 6];
    // string result_dir = argv[argc - 5];
    // int sample_size = atoi(argv[argc - 4]);
    // relink_key_path = argv[argc - 3];
    // galois_key_path = argv[argc - 2];
    // public_key_path = argv[argc - 1];
    string wFilePath = argv[1];
    string xCT = argv[2];
    string bFilePath = argv[3];

    string result_name = argv[argc - 4];
    string result_dir = argv[argc - 3];
    int sample_size = atoi(argv[argc - 2]);
    key_dir = argv[argc - 1];

    if (xCT == "" || result_name == "" || result_dir == "" || sample_size == 0 || key_dir == "")
    {
        // error handling
        cout << "[ERROR] please enter a source path, data paths, output ciphertext file name or prefix, output "
                "ciphertext directory, sample size, linking key path, galois key path and public key path"
             << endl;
        return -1;
    }

    // cout << "[ANN Engine] printing matrix w ..... " << endl;
    // print_matrix(temp);

    int result = 0;
    result = ANNProcess(wFilePath, xCT, bFilePath, result_name, result_dir, sample_size, key_dir);

    // error handling
    if (result == -1)
    {
        fprintf(stderr, "error!\n");
    }
    else
    {
        cout << "done";
    }

    // checkSq(source, data, result_name, result_dir, sample_size, relink_key_path, galois_key_path, public_key_path);

    return result;
}

void rotate_2d_matrix_clockwise_impl(
    vector<vector<double>> const &matrix, vector<vector<double>> &rotated_matrix, int const M, int const N)
{
    for (int x = 0; x < N; ++x)
    {
        for (int y = 0; y < M; ++y)
        {
            // cout << "[ANN Engine] ..... "  << matrix[x][y] << endl;
            // Source : https://stackoverflow.com/questions/4780119/2d-euclidean-vector-rotations
            rotated_matrix[y][-x - 1 + N] = matrix[x][y];
        }
    }
}

auto rotate_2d_matrix_clockwise(vector<vector<double>> const &original_matrix) -> vector<vector<double>>
{
    int const M = original_matrix[0].size();
    int const N = original_matrix.size();
    vector<vector<double>> rotated_matrix;
    rotated_matrix.resize(M);
    for (auto x = 0; x < M; ++x)
    {
        rotated_matrix[x].resize(N);
    }
    rotate_2d_matrix_clockwise_impl(original_matrix, rotated_matrix, M, N);
    return rotated_matrix;
}

int ANNProcess(
    string &wFilePath, string &xCT, string &bFilePath, string &result_name, string &result_dir, int &sample_size,
    string &key_dir)
{
    cout << "[ANN Engine] loading matrix w ..... " << endl;
    vector<vector<double>> w;
    load_csv_file(wFilePath, w, 1);
    cout << "[ANN Engine] loading matrix w .....end \n" << endl;

    cout << "[ANN Engine] rotating counter-clockwise matrix w ..... " << endl;
    vector<vector<double>> cw;
    cw = rotate_2d_matrix_clockwise(rotate_2d_matrix_clockwise(rotate_2d_matrix_clockwise(w)));
    cout << "[ANN Engine] rotating counter-clockwise matrix w .....end \n" << endl;

    cout << "[ANN Engine] printing rotated matrix w ..... " << endl;
    print_matrix(cw);
    cout << "[ANN Engine] printing rotated matrix w .....end \n" << endl;

    struct cevaluator_t eval;
    init_operator_ckks(eval, key_dir);

    cout << "[ANN Engine] loading vector x ..... " << endl;
    Ciphertext x;
    load_ciphertext_ckks(eval, x, xCT);
    //  /*
    // Decrypt, decode, and print the result.
    // */
    // struct cdecryptor_t decr;
    // init_operator_ckks(decr, key_dir);
    // decrypt_ciphertext_ckks(decr, cipher_matrix, pod_matrix);
    // decr.decrypt(encrypted_result, plain_result);
    // vector<double> result;
    // encoder.decode(plain_result, result);
    // cout << "    + Computed result ...... Correct." << endl;
    // print_vector(result, 3, 7);
    cout << "[ANN Engine] loading vector x .....end \n" << endl;

    cout << "[ANN Engine] loading vector b ..... " << endl;
    vector<vector<double>> b;
    load_csv_file(bFilePath, b, 1);
    cout << "[ANN Engine] loading vector b .....end \n" << endl;

    // struct cdecryptor_t decr;
    // init_operator_ckks(decr, key_dir);
    struct cencryptor_t encr;
    init_operator_ckks(encr, key_dir);


    // Transform into vector<Plaintext>
    cout << "[ANN Engine] Transform into vector<Plaintext> b_pt ..... " << endl;
    vector<Plaintext> cw_pt;
    for (int i = 0; i < cw.size(); i++)
    {
        // code block to be executed
        Plaintext pt;
        // init_plaintext_ckks(decr, cw[i], pt);
        init_plaintext_ckks(encr, cw[i], pt);
        cw_pt.push_back(pt);
    }
     cout << "[ANN Engine] Transform into vector<Plaintext> b_pt .....end \n" << endl;

    // size_t slot_count = encr.encoder.slot_count();
    cout << encr.ccode->slot_count() << endl;

    cout << "[ANN Engine] Transform into vector<Plaintext> b_pt ..... " << endl;
    vector<Ciphertext> bx_ct;
    cout << "[ANN Engine] awdasfsdfsd ..... " << w.size() << endl;
    // vector<double> null_vector(w.size(), 0ULL);
     vector<double> null_vector;
     null_vector.push_back(2.2);
     null_vector.push_back(2.2);
    // for (int i = 0; i < cw_pt.size(); i++)
    // for (int i = 0; i < 1; i++)
    {
        // code block to be executed
        Plaintext pt;
        init_plaintext_ckks(encr, null_vector, pt);
        // pt.scale() = pow(2.0, 40);
        Ciphertext ct1, ct2, ct3;
        init_ciphertext_ckks(encr, null_vector, ct1);
        init_ciphertext_ckks(encr, null_vector, ct2);
        // ct1.scale() = pow(2.0, 40);
        // ct2.scale() = pow(2.0, 40);

        multiply_plain_inplace_ckks(eval, x, pt);
        // multiply_ciphertext_ckks(eval, ct1, ct2, ct3);
        // add_plain_inplace_ciphertext_ckks(eval, ct1, pt);
        // multiply_plain_inplace_ckks(eval, pt, ct);
        // rescale_to_next_inplace_ckks(eval, ct);
        // bx_ct.push_back(ct);
    }

    // multiply_plain_inplace_ckks(eval, x, pt);

    // init_ciphermatrix

    // struct encryptor_t encr;
    // init_operator_batching(encr, key_dir);

    // // cout << sample_size*data.size() << endl;
    // // cout << encr.bcode->slot_count() << endl;
    // if (sample_size * data.size() > encr.bcode->slot_count() || sample_size > encr.bcode->slot_count() / 2)
    // {
    //     // error handling
    //     delete_operator_batching(encr);
    //     delete_operator_batching(eval);
    //     return -1;
    // }
    // else
    // {
    //     Ciphertext encrypted_result_matrix;
    //     vector<int64_t> result_matrix;
    //     init_ciphermatrix(encr, result_matrix, encrypted_result_matrix);

    //     vector<int64_t> dummy_matrix;
    //     for (size_t i = 0; i < sample_size; i++)
    //     {
    //         dummy_matrix.push_back(1);
    //     }
    //     Ciphertext encrypted_dummy_matrix;
    //     init_ciphermatrix(encr, dummy_matrix, encrypted_dummy_matrix);

    //     // normalize input data if its size is odd
    //     int normalized_data_size;
    //     if (data.size() % 2 == 0)
    //     {
    //         normalized_data_size = data.size();
    //     }
    //     else
    //     {
    //         normalized_data_size = data.size() + 1;
    //     }

    //     int required_range = normalized_data_size * sample_size;
    //     int required_no_row_elements = required_range / 2;
    //     int required_range_row = required_range / 2;

    //     // create padding matrix
    //     int padding_slots = (encr.bcode->slot_count() / 2) - required_range_row;
    //     vector<int64_t> padding_matrix(encr.bcode->slot_count(), 0ULL);
    //     for (size_t i = 0; i < padding_slots; i++)
    //     {
    //         padding_matrix[required_no_row_elements + i] = 1;
    //         padding_matrix[encr.bcode->slot_count() - i] = 1;
    //     }
    //     Ciphertext encrypted_padding_matrix;
    //     init_ciphermatrix(encr, padding_matrix, encrypted_padding_matrix);

    //     if (required_range_row <= encr.bcode->slot_count() && required_range_row > 0)
    //     {
    //         for (int index = 0; index < normalized_data_size / 2; index++)
    //         {
    //             Ciphertext ct1, ct2, ct3;
    //             Ciphertext temp1, temp2;
    //             // cout << "[INFO] loading ciphertext 1" << endl;
    //             load_ciphertext(eval, ct1, source);
    //             // cout << "[INFO] loading ciphertext 2" << endl;
    //             load_ciphertext(eval, ct2, data.at(index));
    //             sub_ciphertext(eval, ct1, ct2, temp1);

    //             if ((normalized_data_size / 2) + index < data.size())
    //             {
    //                 // cout << "[INFO] loading ciphertext 3" << endl;
    //                 load_ciphertext(eval, ct3, data.at((normalized_data_size / 2) + index));
    //                 sub_ciphertext(eval, ct1, ct3, temp2);
    //             }
    //             else
    //             {
    //                 // add dummy vector for oddy data
    //                 temp2 = encrypted_dummy_matrix;
    //             }

    //             eval.eval->rotate_columns_inplace(temp2, eval.gk);
    // add_ciphertext(eval, temp1, temp2, temp1);

    //             add_ciphertext(eval, temp1, encrypted_result_matrix, encrypted_result_matrix);

    //             // avoid the last shift
    //             if (index + 1 != (normalized_data_size / 2))
    //             {
    //                 eval.eval->rotate_rows_inplace(encrypted_result_matrix, -sample_size, eval.gk);
    //             }
    //         }
    //         // add renmaining padding slots
    //         add_ciphertext(eval, encrypted_result_matrix, encrypted_padding_matrix, encrypted_result_matrix);
    //     }

    //     save_ciphertext(encrypted_result_matrix, result_dir + "/" + result_name + ".ct");
    //     delete_operator_batching(encr);
    //     delete_operator_batching(eval);

    return 0;
    // }
}

// int ANNProcess(
//     string &wFilePath, string &xCT, string &bFilePath, string &result_name, string &result_dir, int &sample_size,
//     string &key_dir)
// {
//     struct evaluator_t eval;
//     init_operator_batching(eval, key_dir);

//     struct encryptor_t encr;
//     init_operator_batching(encr, key_dir);

//     // cout << sample_size*data.size() << endl;
//     // cout << encr.bcode->slot_count() << endl;
//     if (sample_size * data.size() > encr.bcode->slot_count() || sample_size > encr.bcode->slot_count() / 2)
//     {
//         // error handling
//         delete_operator_batching(encr);
//         delete_operator_batching(eval);
//         return -1;
//     }
//     else
//     {
//         Ciphertext encrypted_result_matrix;
//         vector<int64_t> result_matrix;
//         init_ciphermatrix(encr, result_matrix, encrypted_result_matrix);

//         vector<int64_t> dummy_matrix;
//         for (size_t i = 0; i < sample_size; i++)
//         {
//             dummy_matrix.push_back(1);
//         }
//         Ciphertext encrypted_dummy_matrix;
//         init_ciphermatrix(encr, dummy_matrix, encrypted_dummy_matrix);

//         // normalize input data if its size is odd
//         int normalized_data_size;
//         if (data.size() % 2 == 0)
//         {
//             normalized_data_size = data.size();
//         }
//         else
//         {
//             normalized_data_size = data.size() + 1;
//         }

//         int required_range = normalized_data_size * sample_size;
//         int required_no_row_elements = required_range / 2;
//         int required_range_row = required_range / 2;

//         // create padding matrix
//         int padding_slots = (encr.bcode->slot_count() / 2) - required_range_row;
//         vector<int64_t> padding_matrix(encr.bcode->slot_count(), 0ULL);
//         for (size_t i = 0; i < padding_slots; i++)
//         {
//             padding_matrix[required_no_row_elements + i] = 1;
//             padding_matrix[encr.bcode->slot_count() - i] = 1;
//         }
//         Ciphertext encrypted_padding_matrix;
//         init_ciphermatrix(encr, padding_matrix, encrypted_padding_matrix);

//         if (required_range_row <= encr.bcode->slot_count() && required_range_row > 0)
//         {
//             for (int index = 0; index < normalized_data_size / 2; index++)
//             {
//                 Ciphertext ct1, ct2, ct3;
//                 Ciphertext temp1, temp2;
//                 // cout << "[INFO] loading ciphertext 1" << endl;
//                 load_ciphertext(eval, ct1, source);
//                 // cout << "[INFO] loading ciphertext 2" << endl;
//                 load_ciphertext(eval, ct2, data.at(index));
//                 sub_ciphertext(eval, ct1, ct2, temp1);

//                 if ((normalized_data_size / 2) + index < data.size())
//                 {
//                     // cout << "[INFO] loading ciphertext 3" << endl;
//                     load_ciphertext(eval, ct3, data.at((normalized_data_size / 2) + index));
//                     sub_ciphertext(eval, ct1, ct3, temp2);
//                 }
//                 else
//                 {
//                     // add dummy vector for oddy data
//                     temp2 = encrypted_dummy_matrix;
//                 }

//                 eval.eval->rotate_columns_inplace(temp2, eval.gk);
//                 add_ciphertext(eval, temp1, temp2, temp1);

//                 add_ciphertext(eval, temp1, encrypted_result_matrix, encrypted_result_matrix);

//                 // avoid the last shift
//                 if (index + 1 != (normalized_data_size / 2))
//                 {
//                     eval.eval->rotate_rows_inplace(encrypted_result_matrix, -sample_size, eval.gk);
//                 }
//             }
//             // add renmaining padding slots
//             add_ciphertext(eval, encrypted_result_matrix, encrypted_padding_matrix, encrypted_result_matrix);
//         }

//         save_ciphertext(encrypted_result_matrix, result_dir + "/" + result_name + ".ct");
//         delete_operator_batching(encr);
//         delete_operator_batching(eval);

//         return 0;
//     }
// }

void sub_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out)
{
    op_st.eval->sub(ct1, ct2, ct_out);
}

void sub_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2)
{
    op_st.eval->sub_inplace(ct1, ct2);
}

void sub_plain_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct, const Plaintext &plain)
{
    op_st.eval->sub_plain_inplace(ct, plain);
}

void negate_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct)
{
    op_st.eval->negate_inplace(ct);
}

void add_plain_inplace_ciphertext(struct evaluator_t &op_st, struct Ciphertext &ct, const Plaintext &plain)
{
    op_st.eval->add_plain_inplace(ct, plain);
}

void add_plain_inplace_ciphertext_ckks(struct cevaluator_t &op_st, struct Ciphertext &ct, const Plaintext &plain)
{
    op_st.eval->add_plain_inplace(ct, plain);
}

void add_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out)
{
    op_st.eval->add(ct1, ct2, ct_out);
}

void add_many_ciphertext(struct evaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out)
{
    op_st.eval->add_many(cts, ct_out);
}

void multiply_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out)
{
    op_st.eval->multiply(ct1, ct2, ct_out);
}

void multiply_ciphertext_ckks(struct cevaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2, Ciphertext &ct_out)
{
    op_st.eval->multiply(ct1, ct2, ct_out);
}

void multiply_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct1, Ciphertext &ct2)
{
    op_st.eval->multiply_inplace(ct1, ct2);
}

void multiply_ciphertexts(struct evaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out)
{
    op_st.eval->multiply_many(cts, op_st.lk, ct_out);
}

void multiply_ciphertexts_ckks(struct cevaluator_t &op_st, vector<Ciphertext> &cts, Ciphertext &ct_out)
{
    op_st.eval->multiply_many(cts, op_st.lk, ct_out);
}

void multiply_plain_inplace_ckks(struct cevaluator_t &op_st, Ciphertext &ct, const Plaintext &plain)
{
    op_st.eval->multiply_plain_inplace(ct, plain);
}

// void multiply_plain_inplace_ckks(struct evaluator_t &op_st, Ciphertext &ct, const Plaintext &plain)
// {
//     op_st.eval->multiply_plain_inplace(ct, plain);
// }

void relinearize_inplace(struct evaluator_t &op_st, Ciphertext &ct)
{
    op_st.eval->relinearize_inplace(ct, op_st.lk);
}

void relinearize(struct evaluator_t &op_st, Ciphertext &ct, Ciphertext &ct_out)
{
    op_st.eval->relinearize(ct, op_st.lk, ct_out);
}

void rescale_to_next_inplace(struct evaluator_t &op_st, Ciphertext &ct)
{
    op_st.eval->rescale_to_next_inplace(ct);
}

void rescale_to_next_inplace_ckks(struct cevaluator_t &op_st, Ciphertext &ct)
{
    op_st.eval->rescale_to_next_inplace(ct);
}

void exponentiate_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct, uint64_t &exponent)
{
    op_st.eval->exponentiate_inplace(ct, exponent, op_st.lk);
}

void mod_switch_to_next_inplace_ciphertext(struct evaluator_t &op_st, Ciphertext &ct)
{
    op_st.eval->mod_switch_to_next_inplace(ct);
}
