/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.service;

import fr.cea.bigpi.fhe.dap.patternsearch.service.FilesStorageService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FilesStorageServiceImpl
implements FilesStorageService {
    @Value(value="${application.seal.uploadDir}")
    private String fileDirStr;
    private Path fileDir;

    @PostConstruct
    public void initService() {
        this.fileDir = Paths.get(this.fileDirStr, new String[0]);
    }

    public void setFileDir(Path fileDir) {
        this.fileDir = fileDir;
    }

    public Path getFileDir() {
        return this.fileDir;
    }

    public void init() {
        try {
            Files.createDirectory(this.fileDir, new FileAttribute[0]);
            System.out.println(this.fileDir.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize folder for upload!");
        }
    }

    public void save(MultipartFile file) {
        try {
            Files.copy(file.getInputStream(), this.fileDir.resolve(file.getOriginalFilename()), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not store the file. Error: " + e.getMessage());
        }
    }

    public void save(MultipartFile file, String filename) {
        try {
            Files.copy(file.getInputStream(), this.fileDir.resolve(filename), new CopyOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not store the file. Error: " + e.getMessage());
        }
    }

    public void saveAll(MultipartFile[] files) {
        for (MultipartFile file : files) {
            this.save(file);
        }
    }

    public Resource load(String filename) {
        try {
            Path file = this.fileDir.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return resource;
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public void deleteAll() {
        FileSystemUtils.deleteRecursively((File)this.fileDir.toFile());
    }

    public Stream<Path> loadAll() {
        try {
            return Files.walk(this.fileDir, 1, new FileVisitOption[0]).filter(path -> !path.equals(this.fileDir)).map(this.fileDir::relativize);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load the files!");
        }
    }

    public static File createEmptyFile(String dir, MultipartFile multipartFile, String name) {
        String originalName = multipartFile.getOriginalFilename();
        File file = new File(dir + originalName);
        try {
            boolean newFile = file.createNewFile();
            if (newFile) {
                return file;
            }
            throw new IOException("Could not save empty file!");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveContain(MultipartFile multipartFile, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.write(multipartFile.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

