/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.controller;

import fr.cea.bigpi.fhe.dap.patternsearch.controller.Controller;
import fr.cea.bigpi.fhe.dap.patternsearch.helper.Tools;
import fr.cea.bigpi.fhe.dap.patternsearch.helper.Zip;
import fr.cea.bigpi.fhe.dap.patternsearch.model.Data;
import fr.cea.bigpi.fhe.dap.patternsearch.service.DataService;
import fr.cea.bigpi.fhe.dap.patternsearch.service.FHEPatternSearchService;
import fr.cea.bigpi.fhe.dap.patternsearch.service.FilesStorageService;
import io.swagger.annotations.ApiParam;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class ControllerImpl
implements Controller {
    @Autowired
    private FHEPatternSearchService fhePatternSearchService;
    @Autowired
    DataService dataService;
    @Autowired
    FilesStorageService storageService;
    @Autowired
    Zip zip;
    @Autowired
    Tools tools;
    static final Logger logger = LoggerFactory.getLogger(ControllerImpl.class);

    public ResponseEntity<String> uploadEncryptedFile(@ApiParam(name="file", value="", example="", required=true) @RequestParam(value="file") MultipartFile file, @ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String partnerID) {
        String message = "";
        try {
            String requestID = UUID.randomUUID().toString();
            String filename = requestID + ".ct";
            byte[] bytes = file.getBytes();
            String path = this.storageService.getFileDir().toString() + "/" + filename;
            Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
            message = requestID;
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        catch (Exception e) {
            message = "Could not upload the file: " + file.getOriginalFilename() + "!";
            e.printStackTrace();
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<byte[]> checkWithEncryptedFile(@ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String partnerID, @ApiParam(name="requestID", value="", example="", required=true) @RequestParam(value="requestID") String requestID) {
        int vectorSize = 102;
        this.fhePatternSearchService.deleteDir(this.fhePatternSearchService.getResultDir() + "requestID.ct");
        List allData = this.dataService.getAllData();
        ArrayList<String> data = new ArrayList<String>();
        for (Data datum : allData) {
            if (!datum.getPartnerId().equals(partnerID)) continue;
            data.add(datum.getContent() + datum.getDataId() + ".ct");
        }
        try {
            List parts = ControllerImpl.chopped(data, (int)vectorSize);
            String fileName = requestID + ".ct";
            String encryptedFilePath = this.storageService.getFileDir() + "/" + fileName;
            String[] resultPaths = new String[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                try {
                    String outputPath = requestID + "." + (i + 1) + "." + parts.size();
                    System.out.println(outputPath);
                    this.fhePatternSearchService.checkData(encryptedFilePath, (ArrayList)parts.get(i), outputPath);
                    resultPaths[i] = this.fhePatternSearchService.getResultDir() + "/" + outputPath + ".ct";
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            boolean isDirCreated = this.tools.creatDir(this.fhePatternSearchService.getResultDir() + "/" + requestID);
            String zipResultPath = this.zip.zipMultipleFiles(this.fhePatternSearchService.getResultDir() + "/" + requestID, requestID, resultPaths);
            for (int i = 0; i < resultPaths.length; ++i) {
                this.fhePatternSearchService.deleteDir(resultPaths[i]);
            }
            Path path = Paths.get(zipResultPath, new String[0]);
            byte[] returnData = Files.readAllBytes(path);
            return new ResponseEntity((Object)returnData, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static <T> List<List<T>> chopped(List<T> list, int L) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int N = list.size();
        for (int i = 0; i < N; i += L) {
            parts.add(new ArrayList<T>(list.subList(i, Math.min(N, i + L))));
        }
        return parts;
    }

    public ResponseEntity<byte[]> downloadEncryptedFile(@ApiParam(name="Id", value="", example="", required=true) @RequestParam(name="Id") Integer Id2, @ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String partnerID) {
        try {
            List allData = this.dataService.getAllData();
            for (Data datum : allData) {
                if (!datum.getPartnerId().equals(partnerID) || !datum.getDataId().equals(Id2)) continue;
                String fileName = Id2 + ".ct";
                String encryptedFilePath = datum.getContent() + fileName;
                Path path = Paths.get(encryptedFilePath, new String[0]);
                byte[] returnData = Files.readAllBytes(path);
                return new ResponseEntity((Object)returnData, HttpStatus.OK);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

