/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/openapi/v1"})
public interface Controller {
    public static final Logger logger = LoggerFactory.getLogger((String)Controller.class.getName());

    @ApiOperation(value="Upload Encrypted File (.ct)", notes="This method uploads an encrypted file and return the requestID number", nickname="uploadEncryptedFile", response=String.class, authorizations={}, tags={"Data For Client"})
    @ApiResponses(value={@ApiResponse(code=200, message="Server response", response=String.class), @ApiResponse(code=400, message="Bad request", response=String.class), @ApiResponse(code=401, message="Unauthorized", response=String.class), @ApiResponse(code=404, message="Not found", response=String.class), @ApiResponse(code=500, message="Error for HTTPS call trustAnchors", response=String.class)})
    @PostMapping(value={"/crud-data-master/check/01-uploadEncryptedFile"})
    @ResponseBody
    public ResponseEntity<String> uploadEncryptedFile(@ApiParam(name="file", value="", example="", required=true) @RequestParam(value="file") MultipartFile var1, @ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String var2);

    @ApiOperation(value="Check If An Uploaded Encrypted File's Information Is In Database", notes="This method checks if an uploaded encrypted file's information exists in database and returns an encrypted .ct file result. The file result is decrypted with 04-decryptCheckedResult. Note that: the requestID number is used in this method generated from the 01-uploadFile", nickname="checkWithEncryptedFile", response=ResponseEntity.class, authorizations={}, tags={"Data For Client"})
    @ApiResponses(value={@ApiResponse(code=200, message="Server response", response=String.class), @ApiResponse(code=400, message="Bad request", response=String.class), @ApiResponse(code=401, message="Unauthorized", response=String.class), @ApiResponse(code=404, message="Not found", response=String.class), @ApiResponse(code=500, message="Error for HTTPS call trustAnchors", response=String.class)})
    @PostMapping(value={"/crud-data-master/check/02-checkWithEncryptedFile"})
    @ResponseBody
    public ResponseEntity<byte[]> checkWithEncryptedFile(@ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String var1, @ApiParam(name="requestID", value="", example="", required=true) @RequestParam(value="requestID") String var2);

    @ApiOperation(value="Download Encrpted File", notes="This method download an encrpted file", nickname="downloadEncrptedFile", response=ResponseEntity.class, authorizations={}, tags={"Data For Client"})
    @ApiResponses(value={@ApiResponse(code=200, message="Server response"), @ApiResponse(code=400, message="Bad request", response=String.class), @ApiResponse(code=401, message="Unauthorized", response=String.class), @ApiResponse(code=404, message="Not found", response=String.class), @ApiResponse(code=500, message="Error for HTTPS call trustAnchors", response=String.class)})
    @PostMapping(value={"/crud-data-master/check/downloadEncryptedFile"})
    public ResponseEntity<byte[]> downloadEncryptedFile(@ApiParam(name="Id", value="", example="", required=true) @RequestParam(name="Id") Integer var1, @ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String var2);
}

