/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.sleuth.sampler.AlwaysSampler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.BasicAuth;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableDiscoveryClient
@EnableSwagger2
@EnableCircuitBreaker
@EnableAutoConfiguration
@Configuration
public class Application {
    @Value(value="${security.activation.status}")
    private boolean securityActivationStatus;
    @Autowired
    private ObjectMapper objectMapper;
    private final String filterPatern = "/openapi/.*";
    private final String basePackage = "fr.cea.bigpi.fhe.dap.patternsearch.controller";

    @PostConstruct
    public void setUp() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public AlwaysSampler defaultSampler() {
        return new AlwaysSampler();
    }

    private ApiInfo metadata() {
        return new ApiInfoBuilder().title("DAP - PARTTERN SEARCH - Analysis Service API documentation").description("This is API documentation for working with DAP - PARTTERN SEARCH - Function Engine").license("CEA 2.0").licenseUrl("http://www.cea.fr/bigpi/licenses/LICENSE-2.0.html").termsOfServiceUrl("").version("1.0.0").contact(new Contact("", "", "contact@cea.fr")).build();
    }

    @Bean
    public Docket documentation() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        docket.apiInfo(this.metadata());
        if (!this.securityActivationStatus) {
            return docket.select().apis(RequestHandlerSelectors.basePackage((String)"fr.cea.bigpi.fhe.dap.patternsearch.controller")).paths(PathSelectors.regex((String)"/openapi/.*")).build();
        }
        return docket.securitySchemes(new ArrayList<BasicAuth>(Arrays.asList(new BasicAuth("basicAuth")))).securityContexts(new ArrayList<SecurityContext>(Arrays.asList(this.securityContext()))).select().apis(RequestHandlerSelectors.basePackage((String)"fr.cea.bigpi.fhe.dap.patternsearch.controller")).paths(PathSelectors.regex((String)"/openapi/.*")).build();
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"/openapi/.*")).build();
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return new ArrayList<SecurityReference>(Arrays.asList(new SecurityReference("basicAuth", authorizationScopes)));
    }
}

