/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.service;

import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FHEService {
    protected Logger logger = LoggerFactory.getLogger((String)FHEService.class.getName());
    private String appName;

    @Autowired
    public FHEService(@Value(value="${spring.application.name}") String appName) {
        this.appName = appName;
    }

    @HystrixCommand(groupKey="FHE_Service", commandKey="FHE_PingService", fallbackMethod="defaultPing")
    public String ping(String userName) {
        return this.appName + " say <" + userName + ">";
    }

    public String defaultPing(String name, Throwable exception) {
        this.logger.info("callling from fallback Ping");
        this.logger.error("real exception : {}", (Object)exception.getMessage());
        return this.appName + "RuntimeException ! from instance to say Hello <" + name + ">";
    }

    @HystrixCommand(groupKey="FHE_Service", commandKey="FHE_AplusBService", fallbackMethod="defaultAplusB")
    public String fhe_executor(String a, String b) throws CompilationFailedException, IOException {
        Binding binding = new Binding();
        GroovyShell shell = new GroovyShell(binding);
        Script scrpt = shell.parse(new File("src/main/groovy/executor.groovy"));
        binding.setVariable("a", (Object)a);
        binding.setVariable("b", (Object)b);
        binding.setVariable("tools", (Object)scrpt);
        String res = (String)shell.evaluate("tools.fhe_aplusb(a, b)");
        return res;
    }

    public String defaultAplusB(String a, String b, Throwable error) {
        this.logger.error("real exception wheen executing a+b : {}", (Object)error.getMessage());
        return null;
    }
}

