/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.service;

import fr.cea.bigpi.fhe.dap.patternsearch.fhe.CommandExecution;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FHEPatternSearchService {
    @Value(value="${application.seal.sealDir}")
    private String sealDir;
    @Value(value="${application.seal.dataDir}")
    private String dataDir;
    @Value(value="${application.seal.resultDir}")
    private String resultDir;
    @Value(value="${application.seal.keyDir}")
    private String keyDir;
    @Value(value="${application.seal.uploadDir}")
    private String uploadDir;
    @Value(value="${application.seal.sample}")
    private int sample;
    @Value(value="${application.seal.filename}")
    private String filename;
    @Value(value="${application.seal.encryptPath}")
    private String encryptPath;
    @Value(value="${application.seal.decryptPath}")
    private String decryptPath;
    @Value(value="${application.seal.decrypCheckedResulttPath}")
    private String decrypCheckedResulttPath;
    @Value(value="${application.seal.evaluatePath}")
    private String evaluatePath;
    CommandExecution ce;

    @PostConstruct
    public void init() {
        this.ce = new CommandExecution();
    }

    public String encrypt(String content, String dir, String filename) {
        System.out.println("HE Engine: Encrypting vector.... start");
        List<String> command = Arrays.asList(this.encryptPath, content, filename, dir, String.valueOf(this.sample), this.keyDir);
        System.out.println("HE Engine: Encrypting vector.... end");
        return this.ce.execCm2(command, this.sealDir);
    }

    public String decrypt(String dir, String filename) throws Exception {
        System.out.println("HE Engine: Decrypting vector.... start");
        List<String> command = Arrays.asList(this.decryptPath, dir + filename + ".ct", String.valueOf(this.sample), this.keyDir);
        String result_string = this.ce.execCm2(command, this.sealDir);
        if (!result_string.isEmpty()) {
            System.out.println(result_string);
            result_string = FHEPatternSearchService.convertASCII2Data((String)result_string);
            System.out.println("HE Engine: Decrypting vector.... end");
            return result_string;
        }
        System.out.println("The return result is empty! Vector decrypting failed! \n HE Engine: Decrypting vector....end");
        return dir;
    }

    public String createDir(String dir) {
        System.out.println("HE Engine: Creating directories....");
        List<String> command = Arrays.asList("mkdir", "-p", dir);
        return this.ce.execCm2(command, this.sealDir);
    }

    public String deleteDir(String dir) {
        System.out.println("HE Engine: Deleting " + dir + "....");
        List<String> command = Arrays.asList("rm", "-r", dir);
        return this.ce.execCm2(command, this.sealDir);
    }

    public String createDataDir(String uniqueID) {
        String path = this.dataDir + uniqueID + "/";
        this.createDir(path);
        System.out.println("HE Engine: Creating directory: " + path + "....");
        return path;
    }

    public String createUUID4Data(String content, String filename) {
        String uniqueID = UUID.randomUUID().toString();
        String path = this.dataDir + uniqueID + "/";
        this.createDir(path);
        System.out.println("HE Engine: Creating directory: " + path + "....");
        content = FHEPatternSearchService.convertData2ASCII((String)content);
        System.out.println(content);
        this.encrypt(content, path, filename);
        return path;
    }

    public String createID4Data(String content, int id) {
        String uniqueID = String.valueOf(id);
        String path = this.dataDir + uniqueID + "/";
        this.createDir(path);
        System.out.println("HE Engine: Creating data in " + path + "....");
        content = FHEPatternSearchService.convertData2ASCII((String)content);
        System.out.println(content);
        this.encrypt(content, path, uniqueID);
        return path;
    }

    public String createData(String content, String dir, String filename) {
        System.out.println("HE Engine: Creating data in " + dir + "....");
        this.createDir(dir);
        content = FHEPatternSearchService.convertData2ASCII((String)content);
        this.encrypt(content, dir, filename);
        return dir;
    }

    public static String convertData2ASCII(String content) {
        System.out.println("HE Engine: Converting content string to ASCII....");
        byte[] ascii = content.getBytes(StandardCharsets.US_ASCII);
        String asciiString = Arrays.toString(ascii);
        asciiString = asciiString.replace("[", "").replace("]", "").replace(", ", " ");
        return asciiString;
    }

    public static String convertASCII2Data(String asciiString) {
        System.out.println("HE Engine: Converting ASCII to content string...." + asciiString);
        String[] asciiStringSplited = asciiString.replace("\n", "").split("\\s+");
        int size = asciiStringSplited.length;
        byte[] asciiArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            try {
                asciiArray[i] = (byte)Integer.parseInt(asciiStringSplited[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String content = new String(asciiArray, StandardCharsets.US_ASCII);
        content = content.replaceAll("\u0000", "");
        return content;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String decryptCheckResult(String dir) throws Exception {
        System.out.println("HE Engine: Decrypting HE muti-bit array.... start");
        List<String> command = Arrays.asList(this.decrypCheckedResulttPath, dir, String.valueOf(this.sample), this.keyDir);
        String result_string = this.ce.execCm2(command, this.sealDir);
        if (!result_string.isEmpty()) {
            System.out.println(result_string);
            System.out.println("HE Engine: Decrypting vector.... end");
            return result_string;
        }
        System.out.println("The return result is empty! Vector decrypting failed! \n HE Engine: Decrypting vector....end");
        return dir;
    }

    public boolean checkData(String source, ArrayList<String> data, String filename) throws Exception {
        System.out.println("HE Engine: Checking data in " + source + " and " + data + "....");
        ArrayList<String> cm = new ArrayList<String>();
        cm.add(this.evaluatePath);
        cm.add(source);
        cm.addAll(data);
        cm.add(filename);
        cm.add(this.resultDir);
        cm.add(String.valueOf(this.sample));
        cm.add(this.keyDir);
        ArrayList<String> command = cm;
        System.out.println(this.resultDir);
        String result_string = this.ce.execCm2(command, this.sealDir);
        return result_string == "done";
    }

    public boolean stopChecking() {
        return this.ce.destroyProcess();
    }

    public String getSealDir() {
        return this.sealDir;
    }

    public void setSealDir(String sealDir) {
        this.sealDir = sealDir;
    }

    public String getResultDir() {
        return this.resultDir;
    }

    public void setResultDir(String resultDir) {
        this.resultDir = resultDir;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getKeyDir() {
        return this.keyDir;
    }

    public void setKeyDir(String keyDir) {
        this.keyDir = keyDir;
    }

    public int getSample() {
        return this.sample;
    }

    public void setSample(int sample) {
        this.sample = sample;
    }
}

