/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.fhe;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.util.List;

public class CommandExecution {
    private String sysPath = FileSystems.getDefault().getPath("", new String[0]).toAbsolutePath().toString();
    private String OS = System.getProperty("os.name");
    private ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
    private Process process;

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    public void setProcessBuilder(ProcessBuilder processBuilder) {
        this.processBuilder = processBuilder;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public String getSysPath() {
        return this.sysPath;
    }

    public void setSysPath(String sysPath) {
        this.sysPath = sysPath;
    }

    public String getOS() {
        return this.OS;
    }

    public void setOS(String oS) {
        this.OS = oS;
    }

    public boolean isWindows() {
        return this.getOS().startsWith("Windows");
    }

    public boolean isUnix() {
        return this.getOS().startsWith("Linux");
    }

    public boolean destroyProcess() {
        if (this.process != null) {
            this.process.destroy();
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
            return true;
        }
        return false;
    }

    public String execCm2(List<String> command, String workDir) {
        String content = "";
        this.processBuilder.command(command);
        this.processBuilder.directory(new File(workDir));
        try {
            String line;
            this.process = this.processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                content = content + "\n" + line;
            }
            int exitCode = this.process.waitFor();
            System.out.println("\nExited with error code : " + exitCode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return content;
    }
}

