/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.bigpi.fhe.dap.patternsearch.controller;

import fr.cea.bigpi.fhe.dap.patternsearch.controller.Controller;
import fr.cea.bigpi.fhe.dap.patternsearch.helper.Tools;
import fr.cea.bigpi.fhe.dap.patternsearch.helper.Zip;
import fr.cea.bigpi.fhe.dap.patternsearch.model.analyticRequestPayload.AnalyticRequestPayload;
import fr.cea.bigpi.fhe.dap.patternsearch.model.analyticRequestPayload.IaiResponse;
import fr.cea.bigpi.fhe.dap.patternsearch.service.AnalysisServices;
import fr.cea.bigpi.fhe.dap.patternsearch.service.FHEPatternSearchService;
import fr.cea.bigpi.fhe.dap.patternsearch.service.FilesStorageService;
import io.swagger.annotations.ApiParam;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class ControllerImpl
implements Controller {
    @Autowired
    private FHEPatternSearchService fhePatternSearchService;
    @Autowired
    FilesStorageService storageService;
    @Autowired
    Zip zip;
    @Autowired
    Tools tools;
    @Autowired
    AnalysisServices analysisServices;
    static final Logger logger = LoggerFactory.getLogger(ControllerImpl.class);

    public ResponseEntity<String> uploadEncryptedFile(@ApiParam(name="file", value="", example="", required=true) @RequestParam(value="file") MultipartFile file, @ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String partnerID) {
        String message = "";
        try {
            String requestID = UUID.randomUUID().toString();
            String filename = requestID + ".ct";
            byte[] bytes = file.getBytes();
            String path = this.storageService.getFileDir().toString() + "/" + filename;
            Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
            message = requestID;
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        catch (Exception e) {
            message = "Could not upload the file: " + file.getOriginalFilename() + "!";
            e.printStackTrace();
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static <T> List<List<T>> chopped(List<T> list, int L) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int N = list.size();
        for (int i = 0; i < N; i += L) {
            parts.add(new ArrayList<T>(list.subList(i, Math.min(N, i + L))));
        }
        return parts;
    }

    public ResponseEntity<byte[]> checkEncryptedFileWList(@ApiParam(name="partnerID", value="", example="", required=true) @RequestParam(value="partnerID") String partnerID, @ApiParam(name="requestID", value="", example="", required=true) @RequestParam(value="requestID") String requestID, @ApiParam(name="dataList", value="", example="", required=true) @RequestParam(value="dataList") List<String> dataList) {
        int vectorSize = 102;
        ArrayList data = new ArrayList();
        data = (ArrayList)dataList;
        try {
            List parts = ControllerImpl.chopped((List)data, (int)vectorSize);
            String fileName = requestID + ".ct";
            String encryptedFilePath = this.storageService.getFileDir() + "/" + fileName;
            String[] resultPaths = new String[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                try {
                    String outputPath = requestID + "." + (i + 1) + "." + parts.size();
                    System.out.println(outputPath);
                    this.fhePatternSearchService.checkData(encryptedFilePath, (ArrayList)parts.get(i), outputPath);
                    resultPaths[i] = this.fhePatternSearchService.getResultDir() + "/" + outputPath + ".ct";
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String zipResultPath = this.zip.zipMultipleFiles(this.fhePatternSearchService.getResultDir() + "/" + requestID, requestID, resultPaths);
            Path path = Paths.get(zipResultPath, new String[0]);
            byte[] returnData = Files.readAllBytes(path);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Disposition", String.format("attachment; filename=\"" + requestID + ".zip\"", new Object[0]));
            return new ResponseEntity((Object)returnData, (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ResponseBody
    public ResponseEntity<byte[]> checkEncryptedFileWDataListAuto(@RequestParam(value="file2bchecked") String file2bchecked, @RequestParam(value="partnerID") String partnerID, @RequestParam(value="dataList") List<String> dataList) {
        try {
            String requestID = UUID.randomUUID().toString();
            String filename = requestID + ".ct";
            String filePath = file2bchecked;
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            String path = this.storageService.getFileDir().toString() + "/" + filename;
            Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
            ResponseEntity zipResultResponse = this.checkEncryptedFileWList(partnerID, requestID, dataList);
            return zipResultResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Async
    public ResponseEntity<String> startAnalytics(@RequestBody AnalyticRequestPayload analyticRequestPayload) {
        try {
            System.out.println(this.fhePatternSearchService.toString());
            this.analysisServices.startAnalysis(analyticRequestPayload, "CEA", "result");
            return new ResponseEntity((Object)"Received Request", HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<String> stopAnalytics(@RequestParam(value="partnerID") String partnerID) {
        String message = "";
        try {
            boolean result = this.fhePatternSearchService.stopChecking();
            message = String.valueOf(result);
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ResponseEntity<String> receiveAnalyticsResult(@RequestBody IaiResponse iaiResponse) {
        String message = "";
        try {
            System.out.println("Received response: " + iaiResponse.getSuccess() + " " + iaiResponse.getValue() + " " + iaiResponse.getResults());
            return new ResponseEntity((Object)message, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResponseEntity((Object)message, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

